/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class ETypeInfo {
    private int etype;
    private byte[] salt = null;
    private static final byte TAG_TYPE = 0;
    private static final byte TAG_VALUE = 1;

    private ETypeInfo() {
    }

    public ETypeInfo(int etype, byte[] salt) {
        this.etype = etype;
        if (salt != null) {
            this.salt = (byte[])salt.clone();
        }
    }

    public Object clone() {
        ETypeInfo etypeInfo = new ETypeInfo();
        etypeInfo.etype = this.etype;
        if (this.salt != null) {
            etypeInfo.salt = new byte[this.salt.length];
            System.arraycopy(this.salt, 0, etypeInfo.salt, 0, this.salt.length);
        }
        return etypeInfo;
    }

    public ETypeInfo(DerValue encoding) throws Asn1Exception, IOException {
        DerValue der = null;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.etype = der.getData().getBigInteger().intValue();
        if (encoding.getData().available() > 0 && ((der = encoding.getData().getDerValue()).getTag() & 0x1F) == 1) {
            this.salt = der.getData().getOctetString();
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.etype);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        if (this.salt != null) {
            temp = new DerOutputStream();
            temp.putOctetString(this.salt);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public int getEType() {
        return this.etype;
    }

    public byte[] getSalt() {
        return this.salt == null ? null : (byte[])this.salt.clone();
    }
}

