/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.ProviderList;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSNameImpl
implements GSSName {
    private GSSManagerImpl gssManager = null;
    private String appNameStr = null;
    private byte[] appNameBytes = null;
    private Oid appNameType = null;
    private String printableName = null;
    private Oid printableNameType = null;
    private HashMap<Oid, GSSNameSpi> elements = null;
    private GSSNameSpi mechElement = null;

    static GSSNameImpl wrapElement(GSSManagerImpl gssManager, GSSNameSpi mechElement) throws GSSException {
        return mechElement == null ? null : new GSSNameImpl(gssManager, mechElement);
    }

    GSSNameImpl(GSSManagerImpl gssManager, GSSNameSpi mechElement) {
        this.gssManager = gssManager;
        this.appNameStr = this.printableName = ((Object)mechElement).toString();
        this.appNameType = this.printableNameType = mechElement.getStringNameType();
        this.mechElement = mechElement;
        this.elements = new HashMap(1);
        this.elements.put(mechElement.getMechanism(), this.mechElement);
    }

    GSSNameImpl(GSSManagerImpl gssManager, Object appName, Oid appNameType) throws GSSException {
        this(gssManager, appName, appNameType, null);
    }

    GSSNameImpl(GSSManagerImpl gssManager, Object appName, Oid appNameType, Oid mech) throws GSSException {
        if (appName == null) {
            throw new GSSExceptionImpl(3, "Cannot import null name");
        }
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        if (NT_EXPORT_NAME.equals(appNameType)) {
            this.importName(gssManager, appName);
        } else {
            this.init(gssManager, appName, appNameType, mech);
        }
    }

    private void init(GSSManagerImpl gssManager, Object appName, Oid appNameType, Oid mech) throws GSSException {
        this.gssManager = gssManager;
        this.elements = new HashMap(gssManager.getMechs().length);
        if (appName instanceof String) {
            this.appNameStr = (String)appName;
            if (appNameType != null) {
                this.printableName = this.appNameStr;
                this.printableNameType = appNameType;
            }
        } else {
            this.appNameBytes = (byte[])appName;
        }
        this.appNameType = appNameType;
        this.mechElement = this.getElement(mech);
        if (this.printableName == null) {
            this.printableName = ((Object)this.mechElement).toString();
            this.printableNameType = this.mechElement.getStringNameType();
        }
    }

    private void importName(GSSManagerImpl gssManager, Object appName) throws GSSException {
        int pos = 0;
        byte[] bytes = null;
        if (appName instanceof String) {
            try {
                bytes = ((String)appName).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            bytes = (byte[])appName;
        }
        if (bytes[pos++] != 4 || bytes[pos++] != 1) {
            throw new GSSExceptionImpl(3, "Exported name token id is corrupted!");
        }
        int oidLen = (0xFF & bytes[pos++]) << 8 | 0xFF & bytes[pos++];
        ObjectIdentifier temp = null;
        try {
            DerInputStream din = new DerInputStream(bytes, pos, oidLen);
            temp = new ObjectIdentifier(din);
        }
        catch (IOException e) {
            throw new GSSExceptionImpl(3, "Exported name Object identifier is corrupted!");
        }
        Oid oid = new Oid(temp.toString());
        pos += oidLen;
        int mechPortionLen = (0xFF & bytes[pos++]) << 24 | (0xFF & bytes[pos++]) << 16 | (0xFF & bytes[pos++]) << 8 | 0xFF & bytes[pos++];
        byte[] mechPortion = new byte[mechPortionLen];
        System.arraycopy(bytes, pos, mechPortion, 0, mechPortionLen);
        this.init(gssManager, mechPortion, NT_EXPORT_NAME, oid);
    }

    @Override
    public GSSName canonicalize(Oid mech) throws GSSException {
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        return GSSNameImpl.wrapElement(this.gssManager, this.getElement(mech));
    }

    @Override
    public boolean equals(GSSName other) throws GSSException {
        if (this.isAnonymous() || other.isAnonymous()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof GSSNameImpl)) {
            return this.equals(this.gssManager.createName(((Object)other).toString(), other.getStringNameType()));
        }
        GSSNameImpl that = (GSSNameImpl)other;
        GSSNameSpi myElement = this.mechElement;
        GSSNameSpi element = that.mechElement;
        if (myElement == null && element != null) {
            myElement = this.getElement(element.getMechanism());
        } else if (myElement != null && element == null) {
            element = that.getElement(myElement.getMechanism());
        }
        if (myElement != null && element != null) {
            return myElement.equals(element);
        }
        if (this.appNameType != null && that.appNameType != null) {
            if (!this.appNameType.equals(that.appNameType)) {
                return false;
            }
            byte[] myBytes = null;
            byte[] bytes = null;
            try {
                myBytes = this.appNameStr != null ? this.appNameStr.getBytes("UTF-8") : this.appNameBytes;
                bytes = that.appNameStr != null ? that.appNameStr.getBytes("UTF-8") : that.appNameBytes;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return Arrays.equals(myBytes, bytes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(Object another) {
        try {
            if (another instanceof GSSName) {
                return this.equals((GSSName)another);
            }
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public byte[] export() throws GSSException {
        if (this.mechElement == null) {
            this.mechElement = this.getElement(ProviderList.DEFAULT_MECH_OID);
        }
        byte[] mechPortion = this.mechElement.export();
        byte[] oidBytes = null;
        ObjectIdentifier oid = null;
        try {
            oid = new ObjectIdentifier(this.mechElement.getMechanism().toString());
        }
        catch (IOException e) {
            throw new GSSExceptionImpl(11, "Invalid OID String ");
        }
        DerOutputStream dout = new DerOutputStream();
        try {
            dout.putOID(oid);
        }
        catch (IOException e) {
            throw new GSSExceptionImpl(11, "Could not ASN.1 Encode " + oid.toString());
        }
        oidBytes = dout.toByteArray();
        byte[] retVal = new byte[4 + oidBytes.length + 4 + mechPortion.length];
        int pos = 0;
        retVal[pos++] = 4;
        retVal[pos++] = 1;
        retVal[pos++] = (byte)(oidBytes.length >>> 8);
        retVal[pos++] = (byte)oidBytes.length;
        System.arraycopy(oidBytes, 0, retVal, pos, oidBytes.length);
        pos += oidBytes.length;
        retVal[pos++] = (byte)(mechPortion.length >>> 24);
        retVal[pos++] = (byte)(mechPortion.length >>> 16);
        retVal[pos++] = (byte)(mechPortion.length >>> 8);
        retVal[pos++] = (byte)mechPortion.length;
        System.arraycopy(mechPortion, 0, retVal, pos, mechPortion.length);
        return retVal;
    }

    @Override
    public String toString() {
        return this.printableName;
    }

    @Override
    public Oid getStringNameType() throws GSSException {
        return this.printableNameType;
    }

    @Override
    public boolean isAnonymous() {
        if (this.printableNameType == null) {
            return false;
        }
        return GSSName.NT_ANONYMOUS.equals(this.printableNameType);
    }

    @Override
    public boolean isMN() {
        return true;
    }

    public synchronized GSSNameSpi getElement(Oid mechOid) throws GSSException {
        GSSNameSpi retVal = this.elements.get(mechOid);
        if (retVal == null) {
            retVal = this.appNameStr != null ? this.gssManager.getNameElement(this.appNameStr, this.appNameType, mechOid) : this.gssManager.getNameElement(this.appNameBytes, this.appNameType, mechOid);
            this.elements.put(mechOid, retVal);
        }
        return retVal;
    }

    Set<GSSNameSpi> getElements() {
        return new HashSet<GSSNameSpi>(this.elements.values());
    }

    private static String getNameTypeStr(Oid nameTypeOid) {
        if (nameTypeOid == null) {
            return "(NT is null)";
        }
        if (nameTypeOid.equals(NT_USER_NAME)) {
            return "NT_USER_NAME";
        }
        if (nameTypeOid.equals(NT_HOSTBASED_SERVICE)) {
            return "NT_HOSTBASED_SERVICE";
        }
        if (nameTypeOid.equals(NT_EXPORT_NAME)) {
            return "NT_EXPORT_NAME";
        }
        if (nameTypeOid.equals(GSSUtil.NT_GSS_KRB5_PRINCIPAL)) {
            return "NT_GSS_KRB5_PRINCIPAL";
        }
        return "Unknown";
    }
}

