/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.sourceforge.jnlp.security.HttpsCertVerifier;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import sun.security.util.HostnameChecker;
import sun.security.validator.ValidatorException;

public class VariableX509TrustManager
extends X509ExtendedTrustManager {
    KeyStore userKeyStore = null;
    KeyStore caKeyStore = null;
    X509TrustManager userTrustManager = null;
    X509TrustManager caTrustManager = null;
    ArrayList<Certificate> temporarilyTrusted = new ArrayList();
    static VariableX509TrustManager instance = null;

    public VariableX509TrustManager() {
        int i;
        TrustManager[] trustManagers;
        TrustManagerFactory tmFactory;
        try {
            this.userKeyStore = SecurityUtil.getUserKeyStore();
            tmFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmFactory.init(this.userKeyStore);
            trustManagers = tmFactory.getTrustManagers();
            for (i = 0; i < trustManagers.length; ++i) {
                if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                this.userTrustManager = (X509TrustManager)trustManagers[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.caKeyStore = SecurityUtil.getCacertsKeyStore();
            tmFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmFactory.init(this.caKeyStore);
            trustManagers = tmFactory.getTrustManagers();
            for (i = 0; i < trustManagers.length; ++i) {
                if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                this.caTrustManager = (X509TrustManager)trustManagers[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType, String hostName, String algorithm) throws CertificateException {
        try {
            this.caTrustManager.checkClientTrusted(chain, authType);
        }
        catch (Exception caex) {
            try {
                this.userTrustManager.checkClientTrusted(chain, authType);
            }
            catch (Exception userex) {
                // empty catch block
            }
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkClientTrusted(chain, authType, null, null);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType, String hostName, String algorithm) throws CertificateException {
        this.checkServerTrusted(chain, authType, hostName, false);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType, null, null);
    }

    public synchronized void checkServerTrusted(X509Certificate[] chain, String authType, String hostName, boolean checkOnly) throws CertificateException {
        CertificateException ce = null;
        boolean trusted = true;
        boolean CNMatched = true;
        try {
            this.checkAllManagers(chain, authType);
        }
        catch (CertificateException e) {
            trusted = false;
            ce = e;
        }
        if (!this.isExplicitlyTrusted(chain, authType)) {
            try {
                HostnameChecker checker = HostnameChecker.getInstance((byte)1);
                checker.match(hostName, chain[0]);
            }
            catch (CertificateException e) {
                CNMatched = false;
                ce = e;
            }
        }
        if (!trusted || !CNMatched) {
            if (checkOnly) {
                throw ce;
            }
            boolean b = this.askUser(chain, authType, trusted, CNMatched, hostName);
            if (b) {
                this.temporarilyTrust(chain[0]);
            }
            this.checkAllManagers(chain, authType);
        }
    }

    private void checkAllManagers(X509Certificate[] chain, String authType) throws CertificateException {
        block4: {
            try {
                this.caTrustManager.checkServerTrusted(chain, authType);
            }
            catch (ValidatorException caex) {
                try {
                    this.userTrustManager.checkServerTrusted(chain, authType);
                }
                catch (ValidatorException uex) {
                    if (this.temporarilyTrusted.contains(chain[0])) break block4;
                    throw uex;
                }
            }
        }
    }

    private boolean isExplicitlyTrusted(X509Certificate[] chain, String authType) {
        boolean explicitlyTrusted = false;
        try {
            this.userTrustManager.checkServerTrusted(chain, authType);
            explicitlyTrusted = true;
        }
        catch (ValidatorException uex) {
            if (this.temporarilyTrusted.contains(chain[0])) {
                explicitlyTrusted = true;
            }
        }
        catch (CertificateException ce) {
            // empty catch block
        }
        return explicitlyTrusted;
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.caTrustManager.getAcceptedIssuers();
    }

    private void temporarilyTrust(Certificate c) {
        this.temporarilyTrusted.add(c);
    }

    private boolean askUser(X509Certificate[] chain, String authType, boolean isTrusted, boolean hostMatched, String hostName) {
        return SecurityWarningDialog.showCertWarningDialog(SecurityWarningDialog.AccessType.UNVERIFIED, null, new HttpsCertVerifier(this, chain, authType, isTrusted, hostMatched, hostName));
    }

    public static VariableX509TrustManager getInstance() {
        if (instance == null) {
            instance = new VariableX509TrustManager();
        }
        return instance;
    }
}

