/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalProgressBarUI
extends BasicProgressBarUI {
    private Rectangle innards;
    private Rectangle box;

    public static ComponentUI createUI(JComponent c) {
        return new MetalProgressBarUI();
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        super.paintDeterminate(g, c);
        if (!(g instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.isBorderPainted()) {
            Insets b = this.progressBar.getInsets();
            int barRectWidth = this.progressBar.getWidth() - (b.left + b.right);
            int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            boolean isLeftToRight = MetalUtils.isLeftToRight(c);
            int startX = b.left;
            int startY = b.top;
            int endX = b.left + barRectWidth - 1;
            int endY = b.top + barRectHeight - 1;
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f));
            if (this.progressBar.getOrientation() == 0) {
                g2.setColor(MetalLookAndFeel.getControlShadow());
                g2.drawLine(startX, startY, endX, startY);
                if (amountFull > 0) {
                    g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    if (isLeftToRight) {
                        g2.drawLine(startX, startY, startX + amountFull - 1, startY);
                    } else {
                        g2.drawLine(endX, startY, endX - amountFull + 1, startY);
                        if (this.progressBar.getPercentComplete() != 1.0) {
                            g2.setColor(MetalLookAndFeel.getControlShadow());
                        }
                    }
                }
                g2.drawLine(startX, startY, startX, endY);
            } else {
                g2.setColor(MetalLookAndFeel.getControlShadow());
                g2.drawLine(startX, startY, startX, endY);
                if (amountFull > 0) {
                    g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    g2.drawLine(startX, endY, startX, endY - amountFull + 1);
                }
                g2.setColor(MetalLookAndFeel.getControlShadow());
                if (this.progressBar.getPercentComplete() == 1.0) {
                    g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                }
                g2.drawLine(startX, startY, endX, startY);
            }
        }
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        super.paintIndeterminate(g, c);
        if (!this.progressBar.isBorderPainted() || !(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.left + b.right);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        boolean isLeftToRight = MetalUtils.isLeftToRight(c);
        Rectangle box = null;
        box = this.getBox(box);
        int startX = b.left;
        int startY = b.top;
        int endX = b.left + barRectWidth - 1;
        int endY = b.top + barRectHeight - 1;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f));
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(MetalLookAndFeel.getControlShadow());
            g2.drawLine(startX, startY, endX, startY);
            g2.drawLine(startX, startY, startX, endY);
            g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g2.drawLine(box.x, startY, box.x + box.width - 1, startY);
        } else {
            g2.setColor(MetalLookAndFeel.getControlShadow());
            g2.drawLine(startX, startY, startX, endY);
            g2.drawLine(startX, startY, endX, startY);
            g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g2.drawLine(startX, box.y, startX, box.y + box.height - 1);
        }
    }
}

