/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import sun.security.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureClassLoader
extends ClassLoader {
    private boolean initialized = false;
    private HashMap<CodeSource, ProtectionDomain> pdcache = new HashMap(11);
    private static final Debug debug = Debug.getInstance("scl");

    protected SecureClassLoader(ClassLoader parent) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected SecureClassLoader() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len, CodeSource cs) {
        if (cs == null) {
            return this.defineClass(name, b, off, len);
        }
        return this.defineClass(name, b, off, len, this.getProtectionDomain(cs));
    }

    protected final Class<?> defineClass(String name, ByteBuffer b, CodeSource cs) {
        if (cs == null) {
            return this.defineClass(name, b, (ProtectionDomain)null);
        }
        return this.defineClass(name, b, this.getProtectionDomain(cs));
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        this.check();
        return new Permissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource cs) {
        if (cs == null) {
            return null;
        }
        ProtectionDomain pd = null;
        HashMap<CodeSource, ProtectionDomain> hashMap = this.pdcache;
        synchronized (hashMap) {
            PermissionCollection perms;
            pd = this.pdcache.get(cs);
            if (pd == null && (pd = new ProtectionDomain(cs, perms = this.getPermissions(cs), this, null)) != null) {
                this.pdcache.put(cs, pd);
                if (debug != null) {
                    debug.println(" getPermissions " + pd);
                    debug.println("");
                }
            }
        }
        return pd;
    }

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }
}

