/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.NamedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.RuntimeOperationsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository {
    private final Map<String, Map<String, NamedObject>> domainTb;
    private volatile int nbElements = 0;
    private final String domain;
    private final ReentrantReadWriteLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllMatching(Map<String, NamedObject> moiTb, Set<NamedObject> result, ObjectNamePattern pattern) {
        Map<String, NamedObject> map = moiTb;
        synchronized (map) {
            for (NamedObject no : moiTb.values()) {
                ObjectName on = no.getName();
                if (!pattern.matchKeys(on)) continue;
                result.add(no);
            }
        }
    }

    private void addNewDomMoi(DynamicMBean object, String dom, ObjectName name) {
        HashMap<String, NamedObject> moiTb = new HashMap<String, NamedObject>();
        moiTb.put(name.getCanonicalKeyPropertyListString(), new NamedObject(name, object));
        this.domainTb.put(dom, moiTb);
        ++this.nbElements;
    }

    public static boolean wildmatch(char[] str, char[] pat) {
        int strlen = str.length;
        int patlen = pat.length;
        int pati = 0;
        int stri = 0;
        int starpati = -1;
        int starstri = -1;
        block4: while (true) {
            if (pati < patlen) {
                char patc = pat[pati];
                switch (patc) {
                    case '?': {
                        if (stri == strlen) break;
                        ++stri;
                        ++pati;
                        continue block4;
                    }
                    case '*': {
                        starpati = ++pati;
                        starstri = stri;
                        continue block4;
                    }
                    default: {
                        if (stri < strlen && str[stri] == patc) {
                            ++stri;
                            ++pati;
                            continue block4;
                        } else {
                            break;
                        }
                    }
                }
            } else if (stri == strlen) {
                return true;
            }
            if (starpati < 0 || starstri == strlen) {
                return false;
            }
            pati = starpati;
            stri = ++starstri;
        }
    }

    private NamedObject retrieveNamedObject(ObjectName name) {
        Map<String, NamedObject> moiTb;
        if (name.isPattern()) {
            return null;
        }
        String dom = name.getDomain().intern();
        if (dom.length() == 0) {
            dom = this.domain;
        }
        if ((moiTb = this.domainTb.get(dom)) == null) {
            return null;
        }
        return moiTb.get(name.getCanonicalKeyPropertyListString());
    }

    public Repository(String domain) {
        this(domain, true);
    }

    public Repository(String domain, boolean fairLock) {
        this.lock = new ReentrantReadWriteLock(fairLock);
        this.domainTb = new HashMap<String, Map<String, NamedObject>>(5);
        this.domain = domain != null && domain.length() != 0 ? domain : "DefaultDomain";
        this.domainTb.put(this.domain.intern(), new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() {
        ArrayList<String> result;
        this.lock.readLock().lock();
        try {
            result = new ArrayList<String>(this.domainTb.size());
            for (Map.Entry<String, Map<String, NamedObject>> entry : this.domainTb.entrySet()) {
                Map<String, NamedObject> t = entry.getValue();
                if (t == null || t.size() == 0) continue;
                result.add(entry.getKey());
            }
            Object var6_5 = null;
            this.lock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMBean(DynamicMBean object, ObjectName name) throws InstanceAlreadyExistsException {
        boolean to_default_domain;
        String dom;
        block12: {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, Repository.class.getName(), "addMBean", "name = " + name);
            }
            dom = name.getDomain().intern();
            to_default_domain = false;
            if (dom.length() == 0) {
                try {
                    name = new ObjectName(this.domain + name.toString());
                }
                catch (MalformedObjectNameException e) {
                    if (!JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) break block12;
                    JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, Repository.class.getName(), "addMBean", "Unexpected MalformedObjectNameException", e);
                }
            }
        }
        if (dom == this.domain) {
            to_default_domain = true;
            dom = this.domain;
        } else {
            to_default_domain = false;
        }
        if (name.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: cannot add mbean for pattern name " + name.toString()));
        }
        this.lock.writeLock().lock();
        try {
            if (!to_default_domain && dom.equals("JMImplementation") && this.domainTb.containsKey("JMImplementation")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Repository: domain name cannot be JMImplementation"));
            }
            Map<String, NamedObject> moiTb = this.domainTb.get(dom);
            if (moiTb == null) {
                this.addNewDomMoi(object, dom, name);
                Object var9_7 = null;
                this.lock.writeLock().unlock();
                return;
            }
            String cstr = name.getCanonicalKeyPropertyListString();
            NamedObject elmt = moiTb.get(cstr);
            if (elmt != null) {
                throw new InstanceAlreadyExistsException(name.toString());
            }
            ++this.nbElements;
            moiTb.put(cstr, new NamedObject(name, object));
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        Object var9_8 = null;
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ObjectName name) {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, Repository.class.getName(), "contains", " name = " + name);
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.retrieveNamedObject(name) != null;
            Object var4_3 = null;
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicMBean retrieve(ObjectName name) {
        NamedObject no;
        block4: {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, Repository.class.getName(), "retrieve", "name = " + name);
            }
            this.lock.readLock().lock();
            try {
                no = this.retrieveNamedObject(name);
                if (no != null) break block4;
                DynamicMBean dynamicMBean = null;
                Object var5_5 = null;
                this.lock.readLock().unlock();
                return dynamicMBean;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        DynamicMBean dynamicMBean = no.getObject();
        Object var5_6 = null;
        this.lock.readLock().unlock();
        return dynamicMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NamedObject> query(ObjectName pattern, QueryExp query) {
        ObjectNamePattern namePattern;
        boolean allNames;
        ObjectName name;
        HashSet<NamedObject> result;
        block13: {
            block12: {
                block11: {
                    result = new HashSet<NamedObject>();
                    name = null;
                    name = pattern == null || pattern.getCanonicalName().length() == 0 || pattern.equals(ObjectName.WILDCARD) ? ObjectName.WILDCARD : pattern;
                    this.lock.readLock().lock();
                    if (name.isPattern()) break block11;
                    NamedObject no = this.retrieveNamedObject(name);
                    if (no != null) {
                        result.add(no);
                    }
                    HashSet<NamedObject> hashSet = result;
                    Object var14_11 = null;
                    this.lock.readLock().unlock();
                    return hashSet;
                }
                if (name != ObjectName.WILDCARD) break block12;
                for (Map<String, NamedObject> moiTb : this.domainTb.values()) {
                    result.addAll(moiTb.values());
                }
                HashSet<NamedObject> i$ = result;
                Object var14_12 = null;
                this.lock.readLock().unlock();
                return i$;
            }
            String canonical_key_property_list_string = name.getCanonicalKeyPropertyListString();
            allNames = canonical_key_property_list_string.length() == 0;
            ObjectNamePattern objectNamePattern = namePattern = allNames ? null : new ObjectNamePattern(name);
            if (name.getDomain().length() != 0) break block13;
            Map<String, NamedObject> moiTb = this.domainTb.get(this.domain);
            if (allNames) {
                result.addAll(moiTb.values());
            } else {
                this.addAllMatching(moiTb, result, namePattern);
            }
            HashSet<NamedObject> hashSet = result;
            Object var14_13 = null;
            this.lock.readLock().unlock();
            return hashSet;
        }
        try {
            char[] dom2Match = name.getDomain().toCharArray();
            for (String domain : this.domainTb.keySet()) {
                char[] theDom = domain.toCharArray();
                if (!Repository.wildmatch(theDom, dom2Match)) continue;
                Map<String, NamedObject> moiTb = this.domainTb.get(domain);
                if (allNames) {
                    result.addAll(moiTb.values());
                    continue;
                }
                this.addAllMatching(moiTb, result, namePattern);
            }
            HashSet<NamedObject> hashSet = result;
            Object var14_14 = null;
            this.lock.readLock().unlock();
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ObjectName name) throws InstanceNotFoundException {
        String dom;
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, Repository.class.getName(), "remove", "name = " + name);
        }
        if ((dom = name.getDomain().intern()).length() == 0) {
            dom = this.domain;
        }
        this.lock.writeLock().lock();
        try {
            Map<String, NamedObject> moiTb = this.domainTb.get(dom);
            if (moiTb == null) {
                throw new InstanceNotFoundException(name.toString());
            }
            if (moiTb.remove(name.getCanonicalKeyPropertyListString()) == null) {
                throw new InstanceNotFoundException(name.toString());
            }
            --this.nbElements;
            if (moiTb.isEmpty()) {
                this.domainTb.remove(dom);
                if (dom == this.domain) {
                    this.domainTb.put(this.domain, new HashMap());
                }
            }
            Object var5_4 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
    }

    public Integer getCount() {
        return new Integer(this.nbElements);
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectNamePattern {
        private final char[] domain;
        private final String[] keys;
        private final String[] values;
        private final String properties;
        private final boolean isPropertyListPattern;
        private final boolean isPropertyValuePattern;
        public final ObjectName pattern;

        public ObjectNamePattern(ObjectName pattern) {
            this(pattern.getDomain(), pattern.isPropertyListPattern(), pattern.isPropertyValuePattern(), pattern.getCanonicalKeyPropertyListString(), pattern.getKeyPropertyList(), pattern);
        }

        ObjectNamePattern(String domain, boolean propertyListPattern, boolean propertyValuePattern, String canonicalProps, Map<String, String> keyPropertyList, ObjectName pattern) {
            this.domain = domain.toCharArray();
            this.isPropertyListPattern = propertyListPattern;
            this.isPropertyValuePattern = propertyValuePattern;
            this.properties = canonicalProps;
            int len = keyPropertyList.size();
            this.keys = new String[len];
            this.values = new String[len];
            int i = 0;
            for (Map.Entry<String, String> entry : keyPropertyList.entrySet()) {
                this.keys[i] = entry.getKey();
                this.values[i] = entry.getValue();
                ++i;
            }
            this.pattern = pattern;
        }

        public boolean matchKeys(ObjectName name) {
            if (this.isPropertyValuePattern && !this.isPropertyListPattern && name.getKeyPropertyList().size() != this.keys.length) {
                return false;
            }
            if (this.isPropertyValuePattern || this.isPropertyListPattern) {
                for (int i = this.keys.length - 1; i >= 0; --i) {
                    String v = name.getKeyProperty(this.keys[i]);
                    if (v == null) {
                        return false;
                    }
                    if (this.isPropertyValuePattern && this.pattern.isPropertyValuePattern(this.keys[i])) {
                        char[] val_pattern = this.values[i].toCharArray();
                        char[] val_string = v.toCharArray();
                        if (Repository.wildmatch(val_string, val_pattern)) continue;
                        return false;
                    }
                    if (v.equals(this.values[i])) continue;
                    return false;
                }
                return true;
            }
            String p1 = name.getCanonicalKeyPropertyListString();
            String p2 = this.properties;
            return p1.equals(p2);
        }
    }
}

