/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import sun.applet.AppletSecurity;
import sun.applet.PluginDebug;
import sun.applet.PluginMessageHandlerWorker;
import sun.applet.PluginStreamHandler;

class PluginMessageConsumer {
    private static int MAX_PARALLEL_INITS = 1;
    private static int MAX_WORKERS = MAX_PARALLEL_INITS * 5;
    private static int PRIORITY_WORKERS = MAX_PARALLEL_INITS * 2;
    private static Hashtable<Integer, PluginMessageHandlerWorker> initWorkers = new Hashtable(2);
    LinkedList<String> readQueue = new LinkedList();
    private static LinkedList<String> priorityWaitQueue = new LinkedList();
    ArrayList<PluginMessageHandlerWorker> workers = new ArrayList();
    PluginStreamHandler streamHandler = null;
    AppletSecurity as;
    ConsumerThread consumerThread = new ConsumerThread();

    public static void registerPriorityWait(Long reference) {
        PluginDebug.debug("Registering priority for reference " + reference);
        PluginMessageConsumer.registerPriorityWait("reference " + reference.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPriorityWait(String searchString) {
        PluginDebug.debug("Registering priority for string " + searchString);
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            if (!priorityWaitQueue.contains(searchString)) {
                priorityWaitQueue.add(searchString);
            }
        }
    }

    public static void unRegisterPriorityWait(Long reference) {
        PluginMessageConsumer.unRegisterPriorityWait(reference.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unRegisterPriorityWait(String searchString) {
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            priorityWaitQueue.remove(searchString);
        }
    }

    private Long getReference(String[] msgParts) {
        return Long.parseLong(msgParts[3]);
    }

    public PluginMessageConsumer(PluginStreamHandler streamHandler) {
        this.as = new AppletSecurity();
        this.streamHandler = streamHandler;
        this.consumerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPriorityStrIfPriority(String message) {
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            for (String priorityStr : priorityWaitQueue) {
                if (message.indexOf(priorityStr) <= 0) continue;
                return priorityStr;
            }
        }
        return null;
    }

    private boolean isInInit(Integer instanceNum) {
        return initWorkers.containsKey(instanceNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToInitWorkers(Integer instanceNum, PluginMessageHandlerWorker worker) {
        Hashtable<Integer, PluginMessageHandlerWorker> hashtable = initWorkers;
        synchronized (hashtable) {
            initWorkers.put(instanceNum, worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okayToProcess(String[] msgParts) {
        Integer instanceNum;
        if (msgParts[2].equals("tag")) {
            Integer instanceNum2 = new Integer(msgParts[1]);
            Hashtable<Integer, PluginMessageHandlerWorker> hashtable = initWorkers;
            synchronized (hashtable) {
                if (initWorkers.size() >= MAX_PARALLEL_INITS) {
                    return false;
                }
            }
            PluginMessageConsumer.registerPriorityWait("instance " + instanceNum2 + " handle");
            PluginMessageConsumer.registerPriorityWait("instance " + instanceNum2 + " width");
        } else if ((msgParts[2].equals("handle") || msgParts[2].equals("width")) && !this.isInInit(instanceNum = new Integer(msgParts[1]))) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWorkerIsFree(PluginMessageHandlerWorker worker) {
        Hashtable<Integer, PluginMessageHandlerWorker> hashtable = initWorkers;
        synchronized (hashtable) {
            for (Integer key : initWorkers.keySet()) {
                if (!initWorkers.get(key).equals(worker)) continue;
                initWorkers.remove(key);
            }
        }
        this.consumerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(String message) {
        LinkedList<String> linkedList = this.readQueue;
        synchronized (linkedList) {
            this.readQueue.addLast(message);
        }
        this.consumerThread.interrupt();
    }

    private PluginMessageHandlerWorker getFreeWorker(boolean prioritized) {
        for (PluginMessageHandlerWorker worker : this.workers) {
            if (!worker.isFree(prioritized)) continue;
            PluginDebug.debug("Found free worker (" + worker.isPriority() + ") with id " + worker.getWorkerId());
            worker.busy();
            return worker;
        }
        if (this.workers.size() <= MAX_WORKERS) {
            PluginMessageHandlerWorker worker = null;
            if (this.workers.size() <= MAX_WORKERS - PRIORITY_WORKERS) {
                PluginDebug.debug("Cannot find free worker, creating worker " + this.workers.size());
                worker = new PluginMessageHandlerWorker(this, this.streamHandler, this.workers.size(), this.as, false);
            } else if (prioritized) {
                PluginDebug.debug("Cannot find free worker, creating priority worker " + this.workers.size());
                worker = new PluginMessageHandlerWorker(this, this.streamHandler, this.workers.size(), this.as, true);
            } else {
                return null;
            }
            worker.start();
            worker.busy();
            this.workers.add(worker);
            return worker;
        }
        return null;
    }

    protected class ConsumerThread
    extends Thread {
        protected ConsumerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                String message = null;
                LinkedList<String> linkedList = PluginMessageConsumer.this.readQueue;
                synchronized (linkedList) {
                    message = PluginMessageConsumer.this.readQueue.poll();
                }
                if (message != null) {
                    String[] msgParts = message.split(" ");
                    if (!PluginMessageConsumer.this.okayToProcess(msgParts)) {
                        LinkedList<String> linkedList2 = PluginMessageConsumer.this.readQueue;
                        synchronized (linkedList2) {
                            PluginMessageConsumer.this.readQueue.addLast(message);
                        }
                    }
                    String priorityStr = PluginMessageConsumer.this.getPriorityStrIfPriority(message);
                    boolean isPriorityResponse = priorityStr != null;
                    PluginMessageHandlerWorker worker = PluginMessageConsumer.this.getFreeWorker(isPriorityResponse);
                    if (worker == null) {
                        LinkedList<String> linkedList3 = PluginMessageConsumer.this.readQueue;
                        synchronized (linkedList3) {
                            PluginMessageConsumer.this.readQueue.addLast(message);
                        }
                    }
                    if (msgParts[2].equals("tag")) {
                        PluginMessageConsumer.this.addToInitWorkers(new Integer(msgParts[1]), worker);
                    }
                    if (isPriorityResponse) {
                        PluginMessageConsumer.unRegisterPriorityWait(priorityStr);
                    }
                    worker.setmessage(message);
                    worker.interrupt();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

