/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.defaults.JmxProperties;
import java.util.logging.Level;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private Number highThreshold = INTEGER_ZERO;
    private Number lowThreshold = INTEGER_ZERO;
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;

    @Override
    public synchronized void start() {
        if (this.isActive()) {
            JmxProperties.MONITOR_LOGGER.logp(Level.FINER, GaugeMonitor.class.getName(), "start", "the monitor is already active");
            return;
        }
        for (Monitor.ObservedObject o : this.observedObjects) {
            GaugeMonitorObservedObject gmo = (GaugeMonitorObservedObject)o;
            gmo.setStatus(2);
            gmo.setPreviousScanGauge(null);
        }
        this.doStart();
    }

    @Override
    public synchronized void stop() {
        this.doStop();
    }

    @Override
    public synchronized Number getDerivedGauge(ObjectName object) {
        return (Number)super.getDerivedGauge(object);
    }

    @Override
    public synchronized long getDerivedGaugeTimeStamp(ObjectName object) {
        return super.getDerivedGaugeTimeStamp(object);
    }

    @Override
    @Deprecated
    public synchronized Number getDerivedGauge() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return (Number)((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGauge();
    }

    @Override
    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        if (this.observedObjects.isEmpty()) {
            return 0L;
        }
        return ((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGaugeTimeStamp();
    }

    @Override
    public synchronized Number getHighThreshold() {
        return this.highThreshold;
    }

    @Override
    public synchronized Number getLowThreshold() {
        return this.lowThreshold;
    }

    @Override
    public synchronized void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null || lowValue == null) {
            throw new IllegalArgumentException("Null threshold value");
        }
        if (highValue.getClass() != lowValue.getClass()) {
            throw new IllegalArgumentException("Different type threshold values");
        }
        if (this.isFirstStrictlyGreaterThanLast(lowValue, highValue, highValue.getClass().getName())) {
            throw new IllegalArgumentException("High threshold less than low threshold");
        }
        if (this.highThreshold.equals(highValue) && this.lowThreshold.equals(lowValue)) {
            return;
        }
        this.highThreshold = highValue;
        this.lowThreshold = lowValue;
        int index = 0;
        for (Monitor.ObservedObject o : this.observedObjects) {
            this.resetAlreadyNotified(o, index++, 16);
            GaugeMonitorObservedObject gmo = (GaugeMonitorObservedObject)o;
            gmo.setStatus(2);
        }
    }

    @Override
    public synchronized boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    @Override
    public synchronized void setNotifyHigh(boolean value) {
        if (this.notifyHigh == value) {
            return;
        }
        this.notifyHigh = value;
    }

    @Override
    public synchronized boolean getNotifyLow() {
        return this.notifyLow;
    }

    @Override
    public synchronized void setNotifyLow(boolean value) {
        if (this.notifyLow == value) {
            return;
        }
        this.notifyLow = value;
    }

    @Override
    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    @Override
    public synchronized void setDifferenceMode(boolean value) {
        if (this.differenceMode == value) {
            return;
        }
        this.differenceMode = value;
        for (Monitor.ObservedObject o : this.observedObjects) {
            GaugeMonitorObservedObject gmo = (GaugeMonitorObservedObject)o;
            gmo.setStatus(2);
            gmo.setPreviousScanGauge(null);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return (MBeanNotificationInfo[])notifsInfo.clone();
    }

    private synchronized boolean updateDerivedGauge(Object scanGauge, GaugeMonitorObservedObject o) {
        boolean is_derived_gauge_valid;
        if (this.differenceMode) {
            if (o.getPreviousScanGauge() != null) {
                this.setDerivedGaugeWithDifference((Number)scanGauge, o);
                is_derived_gauge_valid = true;
            } else {
                is_derived_gauge_valid = false;
            }
            o.setPreviousScanGauge((Number)scanGauge);
        } else {
            o.setDerivedGauge((Number)scanGauge);
            is_derived_gauge_valid = true;
        }
        return is_derived_gauge_valid;
    }

    private synchronized MonitorNotification updateNotifications(GaugeMonitorObservedObject o) {
        MonitorNotification n = null;
        if (o.getStatus() == 2) {
            if (this.isFirstGreaterThanLast((Number)o.getDerivedGauge(), this.highThreshold, o.getType())) {
                if (this.notifyHigh) {
                    n = new MonitorNotification("jmx.monitor.gauge.high", this, 0L, 0L, "", null, null, null, this.highThreshold);
                }
                o.setStatus(1);
            } else if (this.isFirstGreaterThanLast(this.lowThreshold, (Number)o.getDerivedGauge(), o.getType())) {
                if (this.notifyLow) {
                    n = new MonitorNotification("jmx.monitor.gauge.low", this, 0L, 0L, "", null, null, null, this.lowThreshold);
                }
                o.setStatus(0);
            }
        } else if (o.getStatus() == 0) {
            if (this.isFirstGreaterThanLast((Number)o.getDerivedGauge(), this.highThreshold, o.getType())) {
                if (this.notifyHigh) {
                    n = new MonitorNotification("jmx.monitor.gauge.high", this, 0L, 0L, "", null, null, null, this.highThreshold);
                }
                o.setStatus(1);
            }
        } else if (o.getStatus() == 1 && this.isFirstGreaterThanLast(this.lowThreshold, (Number)o.getDerivedGauge(), o.getType())) {
            if (this.notifyLow) {
                n = new MonitorNotification("jmx.monitor.gauge.low", this, 0L, 0L, "", null, null, null, this.lowThreshold);
            }
            o.setStatus(0);
        }
        return n;
    }

    private synchronized void setDerivedGaugeWithDifference(Number scanGauge, GaugeMonitorObservedObject o) {
        Number der;
        Number prev = o.getPreviousScanGauge();
        switch (o.getType()) {
            case INTEGER: {
                der = new Integer((Integer)scanGauge - (Integer)prev);
                break;
            }
            case BYTE: {
                der = new Byte((byte)((Byte)scanGauge - (Byte)prev));
                break;
            }
            case SHORT: {
                der = new Short((short)((Short)scanGauge - (Short)prev));
                break;
            }
            case LONG: {
                der = new Long((Long)scanGauge - (Long)prev);
                break;
            }
            case FLOAT: {
                der = new Float(((Float)scanGauge).floatValue() - ((Float)prev).floatValue());
                break;
            }
            case DOUBLE: {
                der = new Double((Double)scanGauge - (Double)prev);
                break;
            }
            default: {
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, GaugeMonitor.class.getName(), "setDerivedGaugeWithDifference", "the threshold type is invalid");
                return;
            }
        }
        o.setDerivedGauge(der);
    }

    private boolean isFirstGreaterThanLast(Number greater, Number less, Monitor.NumericalType type) {
        switch (type) {
            case INTEGER: 
            case BYTE: 
            case SHORT: 
            case LONG: {
                return greater.longValue() >= less.longValue();
            }
            case FLOAT: 
            case DOUBLE: {
                return greater.doubleValue() >= less.doubleValue();
            }
        }
        JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, GaugeMonitor.class.getName(), "isFirstGreaterThanLast", "the threshold type is invalid");
        return false;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number greater, Number less, String className) {
        if (className.equals("java.lang.Integer") || className.equals("java.lang.Byte") || className.equals("java.lang.Short") || className.equals("java.lang.Long")) {
            return greater.longValue() > less.longValue();
        }
        if (className.equals("java.lang.Float") || className.equals("java.lang.Double")) {
            return greater.doubleValue() > less.doubleValue();
        }
        JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, GaugeMonitor.class.getName(), "isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
        return false;
    }

    @Override
    Monitor.ObservedObject createObservedObject(ObjectName object) {
        GaugeMonitorObservedObject gmo = new GaugeMonitorObservedObject(object);
        gmo.setStatus(2);
        gmo.setPreviousScanGauge(null);
        return gmo;
    }

    @Override
    synchronized boolean isComparableTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        GaugeMonitorObservedObject o = (GaugeMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return false;
        }
        if (value instanceof Integer) {
            o.setType(Monitor.NumericalType.INTEGER);
        } else if (value instanceof Byte) {
            o.setType(Monitor.NumericalType.BYTE);
        } else if (value instanceof Short) {
            o.setType(Monitor.NumericalType.SHORT);
        } else if (value instanceof Long) {
            o.setType(Monitor.NumericalType.LONG);
        } else if (value instanceof Float) {
            o.setType(Monitor.NumericalType.FLOAT);
        } else if (value instanceof Double) {
            o.setType(Monitor.NumericalType.DOUBLE);
        } else {
            return false;
        }
        return true;
    }

    @Override
    synchronized Comparable<?> getDerivedGaugeFromComparable(ObjectName object, String attribute, Comparable<?> value) {
        GaugeMonitorObservedObject o = (GaugeMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return null;
        }
        o.setDerivedGaugeValid(this.updateDerivedGauge(value, o));
        return (Comparable)o.getDerivedGauge();
    }

    @Override
    synchronized void onErrorNotification(MonitorNotification notification) {
        GaugeMonitorObservedObject o = (GaugeMonitorObservedObject)this.getObservedObject(notification.getObservedObject());
        if (o == null) {
            return;
        }
        o.setStatus(2);
        o.setPreviousScanGauge(null);
    }

    @Override
    synchronized MonitorNotification buildAlarmNotification(ObjectName object, String attribute, Comparable<?> value) {
        GaugeMonitorObservedObject o = (GaugeMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return null;
        }
        MonitorNotification alarm = o.getDerivedGaugeValid() ? this.updateNotifications(o) : null;
        return alarm;
    }

    @Override
    synchronized boolean isThresholdTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        GaugeMonitorObservedObject o = (GaugeMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return false;
        }
        Class<? extends Number> c = GaugeMonitor.classForType(o.getType());
        return GaugeMonitor.isValidForType(this.highThreshold, c) && GaugeMonitor.isValidForType(this.lowThreshold, c);
    }

    static class GaugeMonitorObservedObject
    extends Monitor.ObservedObject {
        private boolean derivedGaugeValid;
        private Monitor.NumericalType type;
        private Number previousScanGauge;
        private int status;

        public GaugeMonitorObservedObject(ObjectName observedObject) {
            super(observedObject);
        }

        public final synchronized boolean getDerivedGaugeValid() {
            return this.derivedGaugeValid;
        }

        public final synchronized void setDerivedGaugeValid(boolean derivedGaugeValid) {
            this.derivedGaugeValid = derivedGaugeValid;
        }

        public final synchronized Monitor.NumericalType getType() {
            return this.type;
        }

        public final synchronized void setType(Monitor.NumericalType type) {
            this.type = type;
        }

        public final synchronized Number getPreviousScanGauge() {
            return this.previousScanGauge;
        }

        public final synchronized void setPreviousScanGauge(Number previousScanGauge) {
            this.previousScanGauge = previousScanGauge;
        }

        public final synchronized int getStatus() {
            return this.status;
        }

        public final synchronized void setStatus(int status) {
            this.status = status;
        }
    }
}

