/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.x11;

import java.awt.Composite;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.SunToolkit;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.image.PixelConverter;
import sun.font.X11TextRenderer;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.ValidatePipe;
import sun.java2d.x11.X11PMBlitBgLoops;
import sun.java2d.x11.X11PMBlitLoops;
import sun.java2d.x11.X11Renderer;
import sun.java2d.x11.X11SurfaceDataProxy;
import sun.java2d.x11.XSurfaceData;
import sun.security.action.GetPropertyAction;

public abstract class X11SurfaceData
extends XSurfaceData {
    X11ComponentPeer peer;
    X11GraphicsConfig graphicsConfig;
    private RenderLoops solidloops;
    protected int depth;
    public static final String DESC_INT_BGR_X11 = "Integer BGR Pixmap";
    public static final String DESC_INT_RGB_X11 = "Integer RGB Pixmap";
    public static final String DESC_BYTE_IND_OPQ_X11 = "Byte Indexed Opaque Pixmap";
    public static final String DESC_INT_BGR_X11_BM = "Integer BGR Pixmap with 1-bit transp";
    public static final String DESC_INT_RGB_X11_BM = "Integer RGB Pixmap with 1-bit transp";
    public static final String DESC_BYTE_IND_X11_BM = "Byte Indexed Pixmap with 1-bit transp";
    public static final String DESC_BYTE_GRAY_X11 = "Byte Gray Opaque Pixmap";
    public static final String DESC_INDEX8_GRAY_X11 = "Index8 Gray Opaque Pixmap";
    public static final String DESC_BYTE_GRAY_X11_BM = "Byte Gray Opaque Pixmap with 1-bit transp";
    public static final String DESC_INDEX8_GRAY_X11_BM = "Index8 Gray Opaque Pixmap with 1-bit transp";
    public static final String DESC_3BYTE_RGB_X11 = "3 Byte RGB Pixmap";
    public static final String DESC_3BYTE_BGR_X11 = "3 Byte BGR Pixmap";
    public static final String DESC_3BYTE_RGB_X11_BM = "3 Byte RGB Pixmap with 1-bit transp";
    public static final String DESC_3BYTE_BGR_X11_BM = "3 Byte BGR Pixmap with 1-bit transp";
    public static final String DESC_USHORT_555_RGB_X11 = "Ushort 555 RGB Pixmap";
    public static final String DESC_USHORT_565_RGB_X11 = "Ushort 565 RGB Pixmap";
    public static final String DESC_USHORT_555_RGB_X11_BM = "Ushort 555 RGB Pixmap with 1-bit transp";
    public static final String DESC_USHORT_565_RGB_X11_BM = "Ushort 565 RGB Pixmap with 1-bit transp";
    public static final String DESC_USHORT_INDEXED_X11 = "Ushort Indexed Pixmap";
    public static final String DESC_USHORT_INDEXED_X11_BM = "Ushort Indexed Pixmap with 1-bit transp";
    public static final SurfaceType IntBgrX11 = SurfaceType.IntBgr.deriveSubType("Integer BGR Pixmap");
    public static final SurfaceType IntRgbX11 = SurfaceType.IntRgb.deriveSubType("Integer RGB Pixmap");
    public static final SurfaceType ThreeByteRgbX11 = SurfaceType.ThreeByteRgb.deriveSubType("3 Byte RGB Pixmap");
    public static final SurfaceType ThreeByteBgrX11 = SurfaceType.ThreeByteBgr.deriveSubType("3 Byte BGR Pixmap");
    public static final SurfaceType UShort555RgbX11 = SurfaceType.Ushort555Rgb.deriveSubType("Ushort 555 RGB Pixmap");
    public static final SurfaceType UShort565RgbX11 = SurfaceType.Ushort565Rgb.deriveSubType("Ushort 565 RGB Pixmap");
    public static final SurfaceType UShortIndexedX11 = SurfaceType.UshortIndexed.deriveSubType("Ushort Indexed Pixmap");
    public static final SurfaceType ByteIndexedOpaqueX11 = SurfaceType.ByteIndexedOpaque.deriveSubType("Byte Indexed Opaque Pixmap");
    public static final SurfaceType ByteGrayX11 = SurfaceType.ByteGray.deriveSubType("Byte Gray Opaque Pixmap");
    public static final SurfaceType Index8GrayX11 = SurfaceType.Index8Gray.deriveSubType("Index8 Gray Opaque Pixmap");
    public static final SurfaceType IntBgrX11_BM = SurfaceType.Custom.deriveSubType("Integer BGR Pixmap with 1-bit transp", PixelConverter.Xbgr.instance);
    public static final SurfaceType IntRgbX11_BM = SurfaceType.Custom.deriveSubType("Integer RGB Pixmap with 1-bit transp", PixelConverter.Xrgb.instance);
    public static final SurfaceType ThreeByteRgbX11_BM = SurfaceType.Custom.deriveSubType("3 Byte RGB Pixmap with 1-bit transp", PixelConverter.Xbgr.instance);
    public static final SurfaceType ThreeByteBgrX11_BM = SurfaceType.Custom.deriveSubType("3 Byte BGR Pixmap with 1-bit transp", PixelConverter.Xrgb.instance);
    public static final SurfaceType UShort555RgbX11_BM = SurfaceType.Custom.deriveSubType("Ushort 555 RGB Pixmap with 1-bit transp", PixelConverter.Ushort555Rgb.instance);
    public static final SurfaceType UShort565RgbX11_BM = SurfaceType.Custom.deriveSubType("Ushort 565 RGB Pixmap with 1-bit transp", PixelConverter.Ushort565Rgb.instance);
    public static final SurfaceType UShortIndexedX11_BM = SurfaceType.Custom.deriveSubType("Ushort Indexed Pixmap with 1-bit transp");
    public static final SurfaceType ByteIndexedX11_BM = SurfaceType.Custom.deriveSubType("Byte Indexed Pixmap with 1-bit transp");
    public static final SurfaceType ByteGrayX11_BM = SurfaceType.Custom.deriveSubType("Byte Gray Opaque Pixmap with 1-bit transp");
    public static final SurfaceType Index8GrayX11_BM = SurfaceType.Custom.deriveSubType("Index8 Gray Opaque Pixmap with 1-bit transp");
    private static Boolean accelerationEnabled = null;
    protected X11Renderer x11pipe;
    protected PixelToShapeConverter x11txpipe;
    protected static TextPipe x11textpipe;
    protected static boolean dgaAvailable;
    private long xgc;
    private Region validatedClip;
    private XORComposite validatedXorComp;
    private int xorpixelmod;
    private int validatedPixel;
    private boolean validatedExposures = true;
    private static LazyPipe lazypipe;

    private static native void initIDs(Class var0, boolean var1);

    protected native void initSurface(int var1, int var2, int var3, long var4);

    public Raster getRaster(int x, int y, int w, int h) {
        throw new InternalError("not implemented yet");
    }

    public static void initX11SurfaceData() {
        if (!X11GraphicsEnvironment.isX11SurfaceDataInitialized() && !GraphicsEnvironment.isHeadless()) {
            String magPresent = AccessController.doPrivileged(new GetPropertyAction("javax.accessibility.screen_magnifier_present"));
            boolean tryDGA = magPresent == null || !"true".equals(magPresent);
            X11SurfaceData.initIDs(XORComposite.class, tryDGA);
            String xtextpipe = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.xtextpipe"));
            if (xtextpipe == null || "true".startsWith(xtextpipe)) {
                if ("true".equals(xtextpipe)) {
                    System.out.println("using X11 text renderer");
                }
                x11textpipe = new X11TextRenderer();
                if (GraphicsPrimitive.tracingEnabled()) {
                    x11textpipe = ((X11TextRenderer)x11textpipe).traceWrap();
                }
            } else {
                if ("false".equals(xtextpipe)) {
                    System.out.println("using DGA text renderer");
                }
                x11textpipe = solidTextRenderer;
            }
            dgaAvailable = X11SurfaceData.isDgaAvailable();
            if (X11SurfaceData.isAccelerationEnabled()) {
                X11PMBlitLoops.register();
                X11PMBlitBgLoops.register();
            }
            X11GraphicsEnvironment.setX11SurfaceDataInitialized();
        }
    }

    public static native boolean isDgaAvailable();

    public static boolean isAccelerationEnabled() {
        if (accelerationEnabled == null) {
            String prop;
            accelerationEnabled = GraphicsEnvironment.isHeadless() ? Boolean.FALSE : ((prop = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.pmoffscreen"))) != null ? Boolean.valueOf(prop) : Boolean.valueOf(!X11SurfaceData.isDgaAvailable()));
        }
        return accelerationEnabled;
    }

    public SurfaceDataProxy makeProxyFor(SurfaceData srcData) {
        return X11SurfaceDataProxy.createProxy(srcData, this.graphicsConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validatePipe(SunGraphics2D sg2d) {
        block21: {
            block22: {
                if (sg2d.antialiasHint == 2) break block21;
                if (sg2d.paintState > 1) break block21;
                if (sg2d.compositeState <= 0) break block22;
                if (sg2d.compositeState != 2) break block21;
            }
            if (this.x11txpipe == null) {
                sg2d.drawpipe = lazypipe;
                sg2d.fillpipe = lazypipe;
                sg2d.shapepipe = lazypipe;
                sg2d.imagepipe = lazypipe;
                sg2d.textpipe = lazypipe;
                return;
            }
            if (sg2d.clipState == 2) {
                super.validatePipe(sg2d);
            } else {
                block0 : switch (sg2d.textAntialiasHint) {
                    case 0: 
                    case 1: {
                        if (sg2d.compositeState == 0) {
                            sg2d.textpipe = x11textpipe;
                            break;
                        }
                        sg2d.textpipe = solidTextRenderer;
                        break;
                    }
                    case 2: {
                        sg2d.textpipe = aaTextRenderer;
                        break;
                    }
                    default: {
                        switch (sg2d.getFontInfo().aaHint) {
                            case 4: 
                            case 6: {
                                sg2d.textpipe = lcdTextRenderer;
                                break block0;
                            }
                            case 1: {
                                if (sg2d.compositeState == 0) {
                                    sg2d.textpipe = x11textpipe;
                                    break block0;
                                }
                                sg2d.textpipe = solidTextRenderer;
                                break block0;
                            }
                            case 2: {
                                sg2d.textpipe = aaTextRenderer;
                                break block0;
                            }
                        }
                        sg2d.textpipe = solidTextRenderer;
                    }
                }
            }
            if (sg2d.transformState >= 3) {
                sg2d.drawpipe = this.x11txpipe;
                sg2d.fillpipe = this.x11txpipe;
            } else if (sg2d.strokeState != 0) {
                sg2d.drawpipe = this.x11txpipe;
                sg2d.fillpipe = this.x11pipe;
            } else {
                sg2d.drawpipe = this.x11pipe;
                sg2d.fillpipe = this.x11pipe;
            }
            sg2d.shapepipe = this.x11pipe;
            sg2d.imagepipe = imagepipe;
            sg2d.loops = this.getRenderLoops(sg2d);
            return;
        }
        super.validatePipe(sg2d);
    }

    public RenderLoops getRenderLoops(SunGraphics2D sg2d) {
        if (sg2d.paintState <= 1) {
            if (sg2d.compositeState <= 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sg2d);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static X11WindowSurfaceData createData(X11ComponentPeer peer) {
        X11GraphicsConfig gc = X11SurfaceData.getGC(peer);
        return new X11WindowSurfaceData(peer, gc, gc.getSurfaceType());
    }

    public static X11PixmapSurfaceData createData(X11GraphicsConfig gc, int width, int height, ColorModel cm, Image image, long drawable, int transparency) {
        return new X11PixmapSurfaceData(gc, width, height, image, X11SurfaceData.getSurfaceType(gc, transparency), cm, drawable, transparency);
    }

    protected X11SurfaceData(X11ComponentPeer peer, X11GraphicsConfig gc, SurfaceType sType, ColorModel cm) {
        super(sType, cm);
        this.peer = peer;
        this.graphicsConfig = gc;
        this.solidloops = this.graphicsConfig.getSolidLoops(sType);
        this.depth = cm.getPixelSize();
        this.initOps(peer, this.graphicsConfig, this.depth);
        if (X11SurfaceData.isAccelerationEnabled()) {
            this.setBlitProxyKey(gc.getProxyKey());
        }
    }

    public static X11GraphicsConfig getGC(X11ComponentPeer peer) {
        if (peer != null) {
            return (X11GraphicsConfig)peer.getGraphicsConfiguration();
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = env.getDefaultScreenDevice();
        return (X11GraphicsConfig)gd.getDefaultConfiguration();
    }

    public abstract boolean canSourceSendExposures(int var1, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyArea(SunGraphics2D sg2d, int x, int y, int w, int h, int dx, int dy) {
        if (this.x11pipe == null) {
            if (!this.isDrawableValid()) {
                return true;
            }
            this.makePipes();
        }
        CompositeType comptype = sg2d.imageComp;
        if (sg2d.transformState < 3 && (CompositeType.SrcOverNoEa.equals(comptype) || CompositeType.SrcNoEa.equals(comptype))) {
            x += sg2d.transX;
            y += sg2d.transY;
            SunToolkit.awtLock();
            try {
                boolean needExposures = this.canSourceSendExposures(x, y, w, h);
                long xgc = this.getBlitGC(sg2d.getCompClip(), needExposures);
                this.x11pipe.devCopyArea(this.getNativeOps(), xgc, x, y, x + dx, y + dy, w, h);
            }
            finally {
                SunToolkit.awtUnlock();
            }
            return true;
        }
        return false;
    }

    public static SurfaceType getSurfaceType(X11GraphicsConfig gc, int transparency) {
        SurfaceType sType;
        boolean transparent = transparency == 2;
        ColorModel cm = gc.getColorModel();
        switch (cm.getPixelSize()) {
            case 24: {
                if (gc.getBitsPerPixel() == 24) {
                    if (cm instanceof DirectColorModel) {
                        sType = transparent ? ThreeByteBgrX11_BM : ThreeByteBgrX11;
                        break;
                    }
                    throw new InvalidPipeException("Unsupported bit depth/cm combo: " + cm.getPixelSize() + ", " + cm);
                }
            }
            case 32: {
                if (cm instanceof DirectColorModel) {
                    if (((DirectColorModel)cm).getRedMask() == 0xFF0000) {
                        sType = transparent ? IntRgbX11_BM : IntRgbX11;
                        break;
                    }
                    sType = transparent ? IntBgrX11_BM : IntBgrX11;
                    break;
                }
                throw new InvalidPipeException("Unsupported bit depth/cm combo: " + cm.getPixelSize() + ", " + cm);
            }
            case 15: {
                sType = transparent ? UShort555RgbX11_BM : UShort555RgbX11;
                break;
            }
            case 16: {
                if (cm instanceof DirectColorModel && ((DirectColorModel)cm).getGreenMask() == 992) {
                    sType = transparent ? UShort555RgbX11_BM : UShort555RgbX11;
                    break;
                }
                sType = transparent ? UShort565RgbX11_BM : UShort565RgbX11;
                break;
            }
            case 12: {
                if (cm instanceof IndexColorModel) {
                    sType = transparent ? UShortIndexedX11_BM : UShortIndexedX11;
                    break;
                }
                throw new InvalidPipeException("Unsupported bit depth: " + cm.getPixelSize() + " cm=" + cm);
            }
            case 8: {
                if (cm.getColorSpace().getType() == 6 && cm instanceof ComponentColorModel) {
                    sType = transparent ? ByteGrayX11_BM : ByteGrayX11;
                    break;
                }
                if (cm instanceof IndexColorModel && X11SurfaceData.isOpaqueGray((IndexColorModel)cm)) {
                    sType = transparent ? Index8GrayX11_BM : Index8GrayX11;
                    break;
                }
                sType = transparent ? ByteIndexedX11_BM : ByteIndexedOpaqueX11;
                break;
            }
            default: {
                throw new InvalidPipeException("Unsupported bit depth: " + cm.getPixelSize());
            }
        }
        return sType;
    }

    public void invalidate() {
        if (this.isValid()) {
            this.setInvalid();
            super.invalidate();
        }
    }

    private static native void XSetCopyMode(long var0);

    private static native void XSetXorMode(long var0);

    private static native void XSetForeground(long var0, int var2);

    public final long getRenderGC(Region clip, int compState, Composite comp, int pixel) {
        return this.getGC(clip, compState, comp, pixel, this.validatedExposures);
    }

    public final long getBlitGC(Region clip, boolean needExposures) {
        return this.getGC(clip, 0, null, this.validatedPixel, needExposures);
    }

    final long getGC(Region clip, int compState, Composite comp, int pixel, boolean needExposures) {
        if (!this.isValid()) {
            throw new InvalidPipeException("bounds changed");
        }
        if (clip != this.validatedClip) {
            this.validatedClip = clip;
            if (clip != null) {
                X11SurfaceData.XSetClip(this.xgc, clip.getLoX(), clip.getLoY(), clip.getHiX(), clip.getHiY(), clip.isRectangular() ? null : clip);
            } else {
                X11SurfaceData.XResetClip(this.xgc);
            }
        }
        if (compState == 0) {
            if (this.validatedXorComp != null) {
                this.validatedXorComp = null;
                this.xorpixelmod = 0;
                X11SurfaceData.XSetCopyMode(this.xgc);
            }
        } else if (this.validatedXorComp != comp) {
            this.validatedXorComp = (XORComposite)comp;
            this.xorpixelmod = this.validatedXorComp.getXorPixel();
            X11SurfaceData.XSetXorMode(this.xgc);
        }
        if ((pixel ^= this.xorpixelmod) != this.validatedPixel) {
            this.validatedPixel = pixel;
            X11SurfaceData.XSetForeground(this.xgc, pixel);
        }
        if (this.validatedExposures != needExposures) {
            this.validatedExposures = needExposures;
            X11SurfaceData.XSetGraphicsExposures(this.xgc, needExposures);
        }
        return this.xgc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makePipes() {
        if (this.x11pipe == null) {
            SunToolkit.awtLock();
            try {
                this.xgc = X11SurfaceData.XCreateGC(this.getNativeOps());
            }
            finally {
                SunToolkit.awtUnlock();
            }
            this.x11pipe = X11Renderer.getInstance();
            this.x11txpipe = new PixelToShapeConverter(this.x11pipe);
        }
    }

    static {
        lazypipe = new LazyPipe();
    }

    public static class LazyPipe
    extends ValidatePipe {
        public boolean validate(SunGraphics2D sg2d) {
            X11SurfaceData xsd = (X11SurfaceData)sg2d.surfaceData;
            if (!xsd.isDrawableValid()) {
                return false;
            }
            xsd.makePipes();
            return super.validate(sg2d);
        }
    }

    public static class X11PixmapSurfaceData
    extends X11SurfaceData {
        Image offscreenImage;
        int width;
        int height;
        int transparency;

        public X11PixmapSurfaceData(X11GraphicsConfig gc, int width, int height, Image image, SurfaceType sType, ColorModel cm, long drawable, int transparency) {
            super(null, gc, sType, cm);
            this.width = width;
            this.height = height;
            this.offscreenImage = image;
            this.transparency = transparency;
            this.initSurface(this.depth, width, height, drawable);
            this.makePipes();
        }

        public SurfaceData getReplacement() {
            return X11PixmapSurfaceData.restoreContents(this.offscreenImage);
        }

        public int getTransparency() {
            return this.transparency;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.width, this.height);
        }

        public boolean canSourceSendExposures(int x, int y, int w, int h) {
            return x < 0 || y < 0 || x + w > this.width || y + h > this.height;
        }

        public void flush() {
            this.invalidate();
            this.flushNativeSurface();
        }

        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class X11WindowSurfaceData
    extends X11SurfaceData {
        public X11WindowSurfaceData(X11ComponentPeer peer, X11GraphicsConfig gc, SurfaceType sType) {
            super(peer, gc, sType, peer.getColorModel());
            if (this.isDrawableValid()) {
                this.makePipes();
            }
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            Rectangle r = this.peer.getBounds();
            r.y = 0;
            r.x = 0;
            return r;
        }

        public boolean canSourceSendExposures(int x, int y, int w, int h) {
            return true;
        }

        public Object getDestination() {
            return this.peer.getTarget();
        }
    }
}

