/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.CenterLayout;
import javax.swing.colorchooser.SmartGridLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultRGBChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    protected JSlider redSlider;
    protected JSlider greenSlider;
    protected JSlider blueSlider;
    protected JSpinner redField;
    protected JSpinner blueField;
    protected JSpinner greenField;
    private final int minValue = 0;
    private final int maxValue = 255;
    private boolean isAdjusting = false;

    public DefaultRGBChooserPanel() {
        this.setInheritsPopupMenu(true);
    }

    private void setColor(Color newColor) {
        int red = newColor.getRed();
        int blue = newColor.getBlue();
        int green = newColor.getGreen();
        if (this.redSlider.getValue() != red) {
            this.redSlider.setValue(red);
        }
        if (this.greenSlider.getValue() != green) {
            this.greenSlider.setValue(green);
        }
        if (this.blueSlider.getValue() != blue) {
            this.blueSlider.setValue(blue);
        }
        if ((Integer)this.redField.getValue() != red) {
            this.redField.setValue(new Integer(red));
        }
        if ((Integer)this.greenField.getValue() != green) {
            this.greenField.setValue(new Integer(green));
        }
        if ((Integer)this.blueField.getValue() != blue) {
            this.blueField.setValue(new Integer(blue));
        }
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.rgbNameText");
    }

    public int getMnemonic() {
        return DefaultRGBChooserPanel.getInt("ColorChooser.rgbMnemonic", -1);
    }

    public int getDisplayedMnemonicIndex() {
        return DefaultRGBChooserPanel.getInt("ColorChooser.rgbDisplayedMnemonicIndex", -1);
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    protected void buildChooser() {
        String redString = UIManager.getString("ColorChooser.rgbRedText");
        String greenString = UIManager.getString("ColorChooser.rgbGreenText");
        String blueString = UIManager.getString("ColorChooser.rgbBlueText");
        this.setLayout(new BorderLayout());
        Color color = this.getColorFromModel();
        JPanel enclosure = new JPanel();
        enclosure.setLayout(new SmartGridLayout(3, 3));
        enclosure.setInheritsPopupMenu(true);
        this.add((Component)enclosure, "Center");
        JLabel l = new JLabel(redString);
        l.setDisplayedMnemonic(AbstractColorChooserPanel.getInt("ColorChooser.rgbRedMnemonic", -1));
        enclosure.add(l);
        this.redSlider = new JSlider(0, 0, 255, color.getRed());
        this.redSlider.setMajorTickSpacing(85);
        this.redSlider.setMinorTickSpacing(17);
        this.redSlider.setPaintTicks(true);
        this.redSlider.setPaintLabels(true);
        this.redSlider.setInheritsPopupMenu(true);
        enclosure.add(this.redSlider);
        this.redField = new JSpinner(new SpinnerNumberModel(color.getRed(), 0, 255, 1));
        l.setLabelFor(this.redSlider);
        this.redField.setInheritsPopupMenu(true);
        JPanel redFieldHolder = new JPanel(new CenterLayout());
        redFieldHolder.setInheritsPopupMenu(true);
        this.redField.addChangeListener(this);
        redFieldHolder.add(this.redField);
        enclosure.add(redFieldHolder);
        l = new JLabel(greenString);
        l.setDisplayedMnemonic(AbstractColorChooserPanel.getInt("ColorChooser.rgbGreenMnemonic", -1));
        enclosure.add(l);
        this.greenSlider = new JSlider(0, 0, 255, color.getGreen());
        this.greenSlider.setMajorTickSpacing(85);
        this.greenSlider.setMinorTickSpacing(17);
        this.greenSlider.setPaintTicks(true);
        this.greenSlider.setPaintLabels(true);
        this.greenSlider.setInheritsPopupMenu(true);
        enclosure.add(this.greenSlider);
        this.greenField = new JSpinner(new SpinnerNumberModel(color.getGreen(), 0, 255, 1));
        l.setLabelFor(this.greenSlider);
        this.greenField.setInheritsPopupMenu(true);
        JPanel greenFieldHolder = new JPanel(new CenterLayout());
        greenFieldHolder.add(this.greenField);
        greenFieldHolder.setInheritsPopupMenu(true);
        this.greenField.addChangeListener(this);
        enclosure.add(greenFieldHolder);
        l = new JLabel(blueString);
        l.setDisplayedMnemonic(AbstractColorChooserPanel.getInt("ColorChooser.rgbBlueMnemonic", -1));
        enclosure.add(l);
        this.blueSlider = new JSlider(0, 0, 255, color.getBlue());
        this.blueSlider.setMajorTickSpacing(85);
        this.blueSlider.setMinorTickSpacing(17);
        this.blueSlider.setPaintTicks(true);
        this.blueSlider.setPaintLabels(true);
        this.blueSlider.setInheritsPopupMenu(true);
        enclosure.add(this.blueSlider);
        this.blueField = new JSpinner(new SpinnerNumberModel(color.getBlue(), 0, 255, 1));
        l.setLabelFor(this.blueSlider);
        this.blueField.setInheritsPopupMenu(true);
        JPanel blueFieldHolder = new JPanel(new CenterLayout());
        blueFieldHolder.add(this.blueField);
        this.blueField.addChangeListener(this);
        blueFieldHolder.setInheritsPopupMenu(true);
        enclosure.add(blueFieldHolder);
        this.redSlider.addChangeListener(this);
        this.greenSlider.addChangeListener(this);
        this.blueSlider.addChangeListener(this);
        this.redSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.greenSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.blueSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
    }

    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.removeAll();
    }

    public void updateChooser() {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.setColor(this.getColorFromModel());
            this.isAdjusting = false;
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JSlider && !this.isAdjusting) {
            int red = this.redSlider.getValue();
            int green = this.greenSlider.getValue();
            int blue = this.blueSlider.getValue();
            Color color = new Color(red, green, blue);
            this.getColorSelectionModel().setSelectedColor(color);
        } else if (e.getSource() instanceof JSpinner && !this.isAdjusting) {
            int red = (Integer)this.redField.getValue();
            int green = (Integer)this.greenField.getValue();
            int blue = (Integer)this.blueField.getValue();
            Color color = new Color(red, green, blue);
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

