/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.DataFormatException;

public class Inflater {
    private long strm;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private boolean finished;
    private boolean needDict;

    public Inflater(boolean nowrap) {
        this.strm = Inflater.init(nowrap);
    }

    public Inflater() {
        this(false);
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buf = b;
        this.off = off;
        this.len = len;
    }

    public void setInput(byte[] b) {
        this.setInput(b, 0, b.length);
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
        if (this.strm == 0L || b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Inflater.setDictionary(this.strm, b, off, len);
        this.needDict = false;
    }

    public void setDictionary(byte[] b) {
        this.setDictionary(b, 0, b.length);
    }

    public synchronized int getRemaining() {
        return this.len;
    }

    public synchronized boolean needsInput() {
        return this.len <= 0;
    }

    public synchronized boolean needsDictionary() {
        return this.needDict;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int inflate(byte[] b, int off, int len) throws DataFormatException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.inflateBytes(b, off, len);
    }

    public int inflate(byte[] b) throws DataFormatException {
        return this.inflate(b, 0, b.length);
    }

    public synchronized int getAdler() {
        this.ensureOpen();
        return Inflater.getAdler(this.strm);
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    public synchronized long getBytesRead() {
        this.ensureOpen();
        return Inflater.getBytesRead(this.strm);
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    public synchronized long getBytesWritten() {
        this.ensureOpen();
        return Inflater.getBytesWritten(this.strm);
    }

    public synchronized void reset() {
        this.ensureOpen();
        Inflater.reset(this.strm);
        this.finished = false;
        this.needDict = false;
        this.len = 0;
        this.off = 0;
    }

    public synchronized void end() {
        if (this.strm != 0L) {
            Inflater.end(this.strm);
            this.strm = 0L;
            this.buf = null;
        }
    }

    protected void finalize() {
        this.end();
    }

    private void ensureOpen() {
        if (this.strm == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs();

    private static native long init(boolean var0);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int inflateBytes(byte[] var1, int var2, int var3) throws DataFormatException;

    private static native int getAdler(long var0);

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        Inflater.initIDs();
    }
}

