/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverManager {
    static final SQLPermission SET_LOG_PERMISSION = new SQLPermission("setLog");
    private static Vector writeDrivers = new Vector();
    private static Vector readDrivers = new Vector();
    private static int loginTimeout = 0;
    private static PrintWriter logWriter = null;
    private static PrintStream logStream = null;
    private static boolean initialized = false;
    private static Object logSync = new Object();

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void setLogWriter(PrintWriter out) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = null;
        logWriter = out;
    }

    public static Connection getConnection(String url, Properties info) throws SQLException {
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(url, info, callerCL);
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        Properties info = new Properties();
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        if (user != null) {
            info.put("user", user);
        }
        if (password != null) {
            info.put("password", password);
        }
        return DriverManager.getConnection(url, info, callerCL);
    }

    public static Connection getConnection(String url) throws SQLException {
        Properties info = new Properties();
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(url, info, callerCL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Driver getDriver(String url) throws SQLException {
        Vector drivers = null;
        DriverManager.println("DriverManager.getDriver(\"" + url + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            drivers = readDrivers;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ClassLoader callerCL = DriverManager.getCallerClassLoader();
            for (int i = 0; i < drivers.size(); ++i) {
                DriverInfo di = (DriverInfo)drivers.elementAt(i);
                if (DriverManager.getCallerClass(callerCL, di.driverClassName) != di.driverClass) {
                    DriverManager.println("    skipping: " + di);
                    continue;
                }
                try {
                    DriverManager.println("    trying " + di);
                    if (!di.driver.acceptsURL(url)) continue;
                    DriverManager.println("getDriver returning " + di);
                    return di.driver;
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            DriverManager.println("getDriver: no suitable driver");
            throw new SQLException("No suitable driver", "08001");
        }
    }

    public static synchronized void registerDriver(Driver driver) throws SQLException {
        if (!initialized) {
            DriverManager.initialize();
        }
        DriverInfo di = new DriverInfo();
        di.driver = driver;
        di.driverClass = driver.getClass();
        di.driverClassName = di.driverClass.getName();
        writeDrivers.addElement(di);
        DriverManager.println("registerDriver: " + di);
        readDrivers = (Vector)writeDrivers.clone();
    }

    public static synchronized void deregisterDriver(Driver driver) throws SQLException {
        int i;
        ClassLoader callerCL = DriverManager.getCallerClassLoader();
        DriverManager.println("DriverManager.deregisterDriver: " + driver);
        DriverInfo di = null;
        for (i = 0; i < writeDrivers.size(); ++i) {
            di = (DriverInfo)writeDrivers.elementAt(i);
            if (di.driver == driver) break;
        }
        if (i >= writeDrivers.size()) {
            DriverManager.println("    couldn't find driver to unload");
            return;
        }
        if (DriverManager.getCallerClass(callerCL, di.driverClassName) != di.driverClass) {
            throw new SecurityException();
        }
        writeDrivers.removeElementAt(i);
        readDrivers = (Vector)writeDrivers.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<Driver> getDrivers() {
        Vector<Driver> result = new Vector<Driver>();
        Vector drivers = null;
        if (!initialized) {
            DriverManager.initialize();
        }
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            drivers = readDrivers;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ClassLoader callerCL = DriverManager.getCallerClassLoader();
            for (int i = 0; i < drivers.size(); ++i) {
                DriverInfo di = (DriverInfo)drivers.elementAt(i);
                if (DriverManager.getCallerClass(callerCL, di.driverClassName) != di.driverClass) {
                    DriverManager.println("    skipping: " + di);
                    continue;
                }
                result.addElement(di.driver);
            }
            return result.elements();
        }
    }

    public static void setLoginTimeout(int seconds) {
        loginTimeout = seconds;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static void setLogStream(PrintStream out) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = out;
        logWriter = out != null ? new PrintWriter(out) : null;
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String message) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(message);
                logWriter.flush();
            }
        }
    }

    private static Class getCallerClass(ClassLoader callerClassLoader, String driverClassName) {
        Class<?> callerC = null;
        try {
            callerC = Class.forName(driverClassName, true, callerClassLoader);
        }
        catch (Exception ex) {
            callerC = null;
        }
        return callerC;
    }

    private static void loadInitialDrivers() {
        String drivers;
        try {
            drivers = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("jdbc.drivers");
                }
            });
        }
        catch (Exception ex) {
            drivers = null;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class);
                Iterator<Driver> driversIterator = loadedDrivers.iterator();
                try {
                    while (driversIterator.hasNext()) {
                        DriverManager.println(" Loading done by the java.util.ServiceLoader :  " + driversIterator.next());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        DriverManager.println("DriverManager.initialize: jdbc.drivers = " + drivers);
        if (drivers == null) {
            return;
        }
        while (drivers.length() != 0) {
            String driver;
            int x = drivers.indexOf(58);
            if (x < 0) {
                driver = drivers;
                drivers = "";
            } else {
                driver = drivers.substring(0, x);
                drivers = drivers.substring(x + 1);
            }
            if (driver.length() == 0) continue;
            try {
                DriverManager.println("DriverManager.Initialize: loading " + driver);
                Class.forName(driver, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception ex) {
                DriverManager.println("DriverManager.Initialize: load failed: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getConnection(String url, Properties info, ClassLoader callerCL) throws SQLException {
        Vector drivers = null;
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            if (callerCL == null) {
                callerCL = Thread.currentThread().getContextClassLoader();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (url == null) {
                throw new SQLException("The url cannot be null", "08001");
            }
            DriverManager.println("DriverManager.getConnection(\"" + url + "\")");
            if (!initialized) {
                DriverManager.initialize();
            }
            clazz = DriverManager.class;
            synchronized (DriverManager.class) {
                drivers = readDrivers;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                SQLException reason = null;
                for (int i = 0; i < drivers.size(); ++i) {
                    DriverInfo di = (DriverInfo)drivers.elementAt(i);
                    if (DriverManager.getCallerClass(callerCL, di.driverClassName) != di.driverClass) {
                        DriverManager.println("    skipping: " + di);
                        continue;
                    }
                    try {
                        DriverManager.println("    trying " + di);
                        Connection result = di.driver.connect(url, info);
                        if (result == null) continue;
                        DriverManager.println("getConnection returning " + di);
                        return result;
                    }
                    catch (SQLException ex) {
                        if (reason != null) continue;
                        reason = ex;
                    }
                }
                if (reason != null) {
                    DriverManager.println("getConnection failed: " + reason);
                    throw reason;
                }
                DriverManager.println("getConnection: no suitable driver found for " + url);
                throw new SQLException("No suitable driver found for " + url, "08001");
            }
        }
    }

    static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        DriverManager.loadInitialDrivers();
        DriverManager.println("JDBC DriverManager initialized");
    }

    private DriverManager() {
    }

    private static native ClassLoader getCallerClassLoader();
}

