/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftMixingDataLine;
import com.sun.media.sound.SoftMixingMixer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoftMixingSourceDataLine
extends SoftMixingDataLine
implements SourceDataLine {
    private boolean open = false;
    private AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private int framesize;
    private int bufferSize = -1;
    private float[] readbuffer;
    private boolean active = false;
    private byte[] cycling_buffer;
    private int cycling_read_pos = 0;
    private int cycling_write_pos = 0;
    private int cycling_avail = 0;
    private long cycling_framepos = 0L;
    private AudioFloatInputStream afis;
    private boolean _active = false;
    private AudioFormat outputformat;
    private int out_nrofchannels;
    private int in_nrofchannels;
    private float _rightgain;
    private float _leftgain;
    private float _eff1gain;
    private float _eff2gain;

    protected SoftMixingSourceDataLine(SoftMixingMixer mixer, DataLine.Info info) {
        super(mixer, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int write(byte[] b, int off, int len) {
        if (!this.isOpen()) {
            return 0;
        }
        if (len % this.framesize != 0) {
            throw new IllegalArgumentException("Number of bytes does not represent an integral number of sample frames.");
        }
        byte[] buff = this.cycling_buffer;
        int buff_len = this.cycling_buffer.length;
        int l = 0;
        while (l != len) {
            int avail;
            byte[] byArray = this.cycling_buffer;
            // MONITORENTER : this.cycling_buffer
            int pos = this.cycling_write_pos;
            for (avail = this.cycling_avail; l != len && avail != buff_len; ++l, ++avail) {
                buff[pos++] = b[off++];
                if (pos != buff_len) continue;
                pos = 0;
            }
            this.cycling_avail = avail;
            this.cycling_write_pos = pos;
            if (l == len) {
                // MONITOREXIT : byArray
                return l;
            }
            // MONITOREXIT : byArray
            if (avail != buff_len) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                return l;
            }
            if (!this.isRunning()) return l;
        }
        return l;
    }

    protected void processControlLogic() {
        this._active = this.active;
        this._rightgain = this.rightgain;
        this._leftgain = this.leftgain;
        this._eff1gain = this.eff1gain;
        this._eff2gain = this.eff2gain;
    }

    protected void processAudioLogic(SoftAudioBuffer[] buffers) {
        if (this._active) {
            int ix;
            int i;
            float[] left = buffers[0].array();
            float[] right = buffers[1].array();
            int bufferlen = buffers[0].getSize();
            int readlen = bufferlen * this.in_nrofchannels;
            if (this.readbuffer == null || this.readbuffer.length < readlen) {
                this.readbuffer = new float[readlen];
            }
            int ret = 0;
            try {
                ret = this.afis.read(this.readbuffer);
                if (ret != this.in_nrofchannels) {
                    Arrays.fill(this.readbuffer, ret, readlen, 0.0f);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            int in_c = this.in_nrofchannels;
            int i2 = 0;
            int ix2 = 0;
            while (i2 < bufferlen) {
                int n = i2++;
                left[n] = left[n] + this.readbuffer[ix2] * this._leftgain;
                ix2 += in_c;
            }
            if (this.out_nrofchannels != 1) {
                if (this.in_nrofchannels == 1) {
                    i2 = 0;
                    ix2 = 0;
                    while (i2 < bufferlen) {
                        int n = i2++;
                        right[n] = right[n] + this.readbuffer[ix2] * this._rightgain;
                        ix2 += in_c;
                    }
                } else {
                    i2 = 0;
                    ix2 = 1;
                    while (i2 < bufferlen) {
                        int n = i2++;
                        right[n] = right[n] + this.readbuffer[ix2] * this._rightgain;
                        ix2 += in_c;
                    }
                }
            }
            if ((double)this._eff1gain > 1.0E-4) {
                float[] eff1 = buffers[2].array();
                i = 0;
                ix = 0;
                while (i < bufferlen) {
                    int n = i++;
                    eff1[n] = eff1[n] + this.readbuffer[ix] * this._eff1gain;
                    ix += in_c;
                }
                if (this.in_nrofchannels == 2) {
                    i = 0;
                    ix = 1;
                    while (i < bufferlen) {
                        int n = i++;
                        eff1[n] = eff1[n] + this.readbuffer[ix] * this._eff1gain;
                        ix += in_c;
                    }
                }
            }
            if ((double)this._eff2gain > 1.0E-4) {
                float[] eff2 = buffers[3].array();
                i = 0;
                ix = 0;
                while (i < bufferlen) {
                    int n = i++;
                    eff2[n] = eff2[n] + this.readbuffer[ix] * this._eff2gain;
                    ix += in_c;
                }
                if (this.in_nrofchannels == 2) {
                    i = 0;
                    ix = 1;
                    while (i < bufferlen) {
                        int n = i++;
                        eff2[n] = eff2[n] + this.readbuffer[ix] * this._eff2gain;
                        ix += in_c;
                    }
                }
            }
        }
    }

    public void open() throws LineUnavailableException {
        this.open(this.format);
    }

    public void open(AudioFormat format) throws LineUnavailableException {
        if (this.bufferSize == -1) {
            this.bufferSize = (int)(format.getFrameRate() / 2.0f) * format.getFrameSize();
        }
        this.open(format, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        LineEvent event = null;
        if (bufferSize < format.getFrameSize() * 32) {
            bufferSize = format.getFrameSize() * 32;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.isOpen()) {
                if (!this.mixer.isOpen()) {
                    this.mixer.open();
                    this.mixer.implicitOpen = true;
                }
                event = new LineEvent(this, LineEvent.Type.OPEN, 0L);
                this.bufferSize = bufferSize - bufferSize % format.getFrameSize();
                this.format = format;
                this.framesize = format.getFrameSize();
                this.outputformat = this.mixer.getFormat();
                this.out_nrofchannels = this.outputformat.getChannels();
                this.in_nrofchannels = format.getChannels();
                this.open = true;
                this.mixer.getMainMixer().openLine(this);
                this.cycling_buffer = new byte[this.framesize * bufferSize];
                this.cycling_read_pos = 0;
                this.cycling_write_pos = 0;
                this.cycling_avail = 0;
                this.cycling_framepos = 0L;
                InputStream cycling_inputstream = new InputStream(){

                    public int read() throws IOException {
                        byte[] b = new byte[1];
                        int ret = this.read(b);
                        if (ret < 0) {
                            return ret;
                        }
                        return b[0] & 0xFF;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public int available() throws IOException {
                        byte[] byArray = SoftMixingSourceDataLine.this.cycling_buffer;
                        synchronized (byArray) {
                            return SoftMixingSourceDataLine.this.cycling_avail;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public int read(byte[] b, int off, int len) throws IOException {
                        byte[] byArray = SoftMixingSourceDataLine.this.cycling_buffer;
                        synchronized (byArray) {
                            if (len > SoftMixingSourceDataLine.this.cycling_avail) {
                                len = SoftMixingSourceDataLine.this.cycling_avail;
                            }
                            int pos = SoftMixingSourceDataLine.this.cycling_read_pos;
                            byte[] buff = SoftMixingSourceDataLine.this.cycling_buffer;
                            int buff_len = buff.length;
                            for (int i = 0; i < len; ++i) {
                                b[off++] = buff[pos];
                                if (++pos != buff_len) continue;
                                pos = 0;
                            }
                            SoftMixingSourceDataLine.this.cycling_read_pos = pos;
                            SoftMixingSourceDataLine.this.cycling_avail -= len;
                            SoftMixingSourceDataLine.this.cycling_framepos += len / SoftMixingSourceDataLine.this.framesize;
                        }
                        return len;
                    }
                };
                this.afis = AudioFloatInputStream.getInputStream(new AudioInputStream(cycling_inputstream, format, -1L));
                this.afis = new NonBlockingFloatInputStream(this.afis);
                if ((double)Math.abs(format.getSampleRate() - this.outputformat.getSampleRate()) > 1.0E-6) {
                    this.afis = new SoftMixingDataLine.AudioFloatInputStreamResampler(this.afis, this.outputformat);
                }
            } else if (!format.matches(this.getFormat())) {
                throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
            }
        }
        if (event != null) {
            this.sendEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        byte[] byArray = this.cycling_buffer;
        synchronized (this.cycling_buffer) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cycling_buffer.length - this.cycling_avail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void drain() {
        while (true) {
            byte[] byArray = this.cycling_buffer;
            // MONITORENTER : this.cycling_buffer
            int avail = this.cycling_avail;
            // MONITOREXIT : byArray
            if (avail != 0) {
                return;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        byte[] byArray = this.cycling_buffer;
        synchronized (this.cycling_buffer) {
            this.cycling_read_pos = 0;
            this.cycling_write_pos = 0;
            this.cycling_avail = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferSize() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.bufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFormat getFormat() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.format;
        }
    }

    public int getFramePosition() {
        return (int)this.getLongFramePosition();
    }

    public float getLevel() {
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongFramePosition() {
        byte[] byArray = this.cycling_buffer;
        synchronized (this.cycling_buffer) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cycling_framepos;
        }
    }

    public long getMicrosecondPosition() {
        return (long)((double)this.getLongFramePosition() * (1000000.0 / (double)this.getFormat().getSampleRate()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LineEvent event = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.active) {
                    return;
                }
                this.active = true;
                event = new LineEvent(this, LineEvent.Type.START, this.getLongFramePosition());
            }
        }
        if (event != null) {
            this.sendEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LineEvent event = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                event = new LineEvent(this, LineEvent.Type.STOP, this.getLongFramePosition());
            }
        }
        if (event != null) {
            this.sendEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LineEvent event = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.isOpen()) {
                return;
            }
            this.stop();
            event = new LineEvent(this, LineEvent.Type.CLOSE, this.getLongFramePosition());
            this.open = false;
            this.mixer.getMainMixer().closeLine(this);
        }
        if (event != null) {
            this.sendEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.open;
        }
    }

    private static class NonBlockingFloatInputStream
    extends AudioFloatInputStream {
        AudioFloatInputStream ais;

        public NonBlockingFloatInputStream(AudioFloatInputStream ais) {
            this.ais = ais;
        }

        public int available() throws IOException {
            return this.ais.available();
        }

        public void close() throws IOException {
            this.ais.close();
        }

        public AudioFormat getFormat() {
            return this.ais.getFormat();
        }

        public long getFrameLength() {
            return this.ais.getFrameLength();
        }

        public void mark(int readlimit) {
            this.ais.mark(readlimit);
        }

        public boolean markSupported() {
            return this.ais.markSupported();
        }

        public int read(float[] b, int off, int len) throws IOException {
            int avail = this.available();
            if (len > avail) {
                int ret = this.ais.read(b, off, avail);
                Arrays.fill(b, off + ret, off + len, 0.0f);
                return len;
            }
            return this.ais.read(b, off, len);
        }

        public void reset() throws IOException {
            this.ais.reset();
        }

        public long skip(long len) throws IOException {
            return this.ais.skip(len);
        }
    }
}

