//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "templatewindow.h"
#include "ui_templatewindow.h"

TemplateWindow::TemplateWindow(QWidget *parent, Template* t) :
    QDialog(parent),
    ui(new Ui::TemplateWindow)
{
    ui->setupUi(this);
    m_Template = t;

    if (t->IsValid())
        setWindowTitle(tr("Edit template"));
    else
        setWindowTitle(tr("New template"));
    ui->txtSubject->setText(t->Subject);
    ui->txtText->setPlainText(t->Text);

    connect(ui->btnOk, SIGNAL(clicked()), SLOT(OkSlot()));
}

TemplateWindow::~TemplateWindow()
{
    delete ui;
}

void TemplateWindow::OkSlot()
{
    if (ui->txtText->toPlainText().isEmpty()){
        CommonStatic::ErrorMessage(this, tr("Enter a text"));
        return;
    }

    m_Template->Subject = ui->txtSubject->text();
    m_Template->Text = ui->txtText->toPlainText();
    if (!m_Template->SaveToDb()){
        CommonStatic::ErrorMessage(this, tr("Error saving template"));
        return;
    }
    accept();
}
