//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "group.h"
#include <QSqlQuery>
#include <QSqlRecord>
#include <QSqlResult>
#include <QVariant>
#include "commonstatic.h"

Group::Group()
{
    Id = 0;
}

Group::~Group()
{
    foreach(GroupContact* c, ContactsId)
        delete c;
    ContactsId.clear();
}

bool Group::IsValid()
{
    return Id > 0;
}

bool Group::SaveToDb()
{
    CommonStatic::ExecuteQuery("BEGIN TRANSACTION");

    QString query;
    if (!IsValid()){
        query = QString("Insert into groups (g_name) values('%1')").arg(CommonStatic::EscapeString(Name));
    }else{
        query = QString("update groups set g_name='%1' where g_id=%2").arg(CommonStatic::EscapeString(Name)).arg(Id);
    }

    QSqlQuery qry;
    if (!CommonStatic::ExecuteQuery(query, &qry)){
        CommonStatic::ExecuteQuery("ROLLBACK");
        return false;
    }

    query = QString("delete from group_contacts where gc_group_id=%1").arg(Id);
    if (!CommonStatic::ExecuteQuery(query, &qry)){
        CommonStatic::ExecuteQuery("ROLLBACK");
        return false;
    }

    foreach(GroupContact* c, ContactsId){
        query = QString("insert into group_contacts (gc_group_id, gc_contact_id, gc_number) \
                         values(%1, %2, '%3')").arg(Id).arg(c->Id).arg(c->Number);
        if (!CommonStatic::ExecuteQuery(query, &qry)){
            CommonStatic::ExecuteQuery("ROLLBACK");
            return false;
        }
    }

    CommonStatic::ExecuteQuery("COMMIT");
    return true;
}

bool Group::LoadFromDb()
{
    if (Id <= 0)
        return false;

    QString query = QString("Select g_id, g_name from groups where g_id=%1").arg(Id);
    QSqlQuery qry;
    QSqlRecord rec;
    if (!CommonStatic::ExecuteQuery(query, &qry))
        return false;

    qry.next();    
    if (qry.isValid()){
        rec = qry.record();
        Id = rec.value(0).toInt();
        Name = rec.value(1).toString();
    }

    query = QString("Select gc_contact_id, gc_number from group_contacts where gc_group_id=%1").arg(Id);
    if (!CommonStatic::ExecuteQuery(query, &qry))
        return false;
    while(qry.next()){
        rec = qry.record();

        GroupContact* c = new GroupContact();
        c->Id = rec.value(0).toInt();
        c->Number = rec.value(1).toString();
        ContactsId.append(c);
    }

    return true;
}

bool Group::Exists(QString Name)
{
    QString query = QString("Select 1 from groups where g_name='%1'").arg(CommonStatic::EscapeString(Name));
    QSqlQuery qry;
    if (!CommonStatic::ExecuteQuery(query, &qry))
        return false;

    qry.next();
    if (qry.isValid())
        return true;
    return false;
}

QList<Group*> Group::GetGroupList()
{
    QList<Group*> res;

    QString query = QString("Select g_id from groups order by g_name");
    QSqlQuery qry;
    if (!CommonStatic::ExecuteQuery(query, &qry))
        return res;

    QSqlRecord rec;
    while(qry.next()){
        rec = qry.record();
        Group* g = new Group();
        g->Id = rec.value(0).toInt();
        if (g->LoadFromDb())
            res.append(g);
    }

    return res;
}

bool Group::Contains(QString number)
{
    foreach (GroupContact* gc, ContactsId){
        if (gc->Number == number)
            return true;
    }
    return false;
}

void Group::Remove(QString number)
{
    QList<GroupContact*> toRemove;

    foreach (GroupContact* gc, ContactsId){
        if (gc->Number == number)
            toRemove.append(gc);
    }

    foreach (GroupContact* gc, toRemove){
        ContactsId.removeAll(gc);
        delete gc;
    }
}

bool Group::Delete()
{
    if (!IsValid())
        return false;

    QString query = QString("Delete from groups where g_id=%1").arg(Id);
    QSqlQuery qry;
    if (!CommonStatic::ExecuteQuery(query, &qry))
        return false;

    query = QString("Delete from group_contacts where gc_group_id=%1").arg(Id);
    if (!CommonStatic::ExecuteQuery(query, &qry))
        return false;
    return true;
}

int Group::RemoveInvalidNumbers()
{
    QList<GroupContact*> toRemove;

    foreach (GroupContact* gc, ContactsId){
        Contact* c = CommonStatic::GetContact(gc->Number);
        if (c == NULL)
            toRemove.append(gc);
        else
            gc->Id = c->Id;
    }

    foreach (GroupContact* gc, toRemove){
        ContactsId.removeAll(gc);
        delete gc;
    }
    return toRemove.count();
}
