//    GroupSMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "contactsloader.h"
#include <QFile>
#include <QSettings>
#include "contact.h"
#include "commonstatic.h"


bool toAscending(const Contact* s1 , const Contact* s2)
{
    return QString::compare(s1->Name, s2->Name, Qt::CaseInsensitive) < 0;
}

void ContactsLoader::run()
{    
#ifdef Q_OS_SYMBIAN
    setStackSize(163840);
#endif
    CommonStatic::ContactsCache.clear();
    CommonStatic::ContactsCacheNumbers.clear();
    CommonStatic::ContactsCacheIds.clear();
    QStringList* numbers = new QStringList();

#if defined(Q_WS_MAEMO_5) || defined(Q_OS_SYMBIAN)
    //Symbian and Maemo implementation (read phonebook from phone)
    //Collect contacts from all managers:
    QContactManager* man = NULL;
    QStringList availableManagers = QContactManager::availableManagers();
    QList<QContact> contacts;
    while (!availableManagers.isEmpty()) {
        man = new QContactManager(availableManagers.takeFirst());

#ifdef Q_WS_MAEMO_5
        QList<QContact> tContacts = man->contacts();
        if (!tContacts.isEmpty()){
            contacts.append(tContacts);
            tContacts.clear();
        }
#endif

        delete man;
        man = NULL;
    }

    numbers->clear();
    if (!contacts.isEmpty()){
        foreach (QContact c, contacts){
            if (!c.isEmpty() && c.type() == QContactType::TypeContact){
                QStringList* cEmails = new QStringList();
                QList<QContactDetail> emails = c.details(QContactEmailAddress::DefinitionName);
                foreach (QContactDetail detail, emails){
                    QContactEmailAddress* eml = (QContactEmailAddress*)(&detail);
                    cEmails->append(eml->emailAddress());
                }

                QList<QContactDetail> phns = c.details(QContactPhoneNumber::DefinitionName);
                foreach (QContactDetail detail, phns){
                    QContactPhoneNumber* phn = (QContactPhoneNumber*)(&detail);
                    QString number = phn->number();
                    if (!numbers->contains(number)){
                        numbers->append(number);
                        Contact* contact = new Contact();
                        contact->Id = c.localId();
                        contact->Name = c.displayLabel();
                        contact->Number = number;
                        contact->eMails = cEmails;

                        QContactThumbnail thn = c.detail(QContactThumbnail::DefinitionName);
                        if (!thn.isEmpty())
                            contact->Thumbnail = new QImage(thn.thumbnail().scaled(48, 48, Qt::KeepAspectRatio));
                        CommonStatic::ContactsCache.append(contact);
                        CommonStatic::ContactsCacheNumbers[contact->Number] = contact;
                        CommonStatic::ContactsCacheIds[contact->Id] = contact;
                    }
                }
            }
        }
    }

#else
    // Windows implementation (read a phonebook from file)
    QString book = QString("%1/contacts.conf").arg(CommonStatic::GetSettingsFolder());
    if (!QFile::exists(book))
        return;

    QSettings* contacts = new QSettings(book, QSettings::IniFormat);

    contacts->beginGroup("Contacts");

    int max = contacts->beginReadArray("items");
    for (int i = 0; i < max; ++i) {
        contacts->setArrayIndex(i);

        Contact* contact = new Contact();
        contact->Id = contacts->value("id").toInt();
        contact->Name = contacts->value("name").toString();
        contact->Number = contacts->value("number").toString();

        CommonStatic::ContactsCache.append(contact);
        CommonStatic::ContactsCacheNumbers[contact->Number] = contact;
        CommonStatic::ContactsCacheIds[contact->Id] = contact;
    }

    contacts->endArray();
    contacts->endGroup();
    delete contacts;
#endif

    delete numbers;
    qSort(CommonStatic::ContactsCache.begin() , CommonStatic::ContactsCache.end(), toAscending );
}
