#ifndef CONTACTSDATAMODEL_H
#define CONTACTSDATAMODEL_H

#include <QAbstractTableModel>
#include <QPixmap>
#include <QTableView>
#include "contact.h"
#include "group.h"

class ContactsDataModel : public QAbstractTableModel
{
    Q_OBJECT

public:
    ContactsDataModel(QObject *parent=0);
    ContactsDataModel(QObject *parent=0, QList<Contact*>* contacts=0);
    ~ContactsDataModel();

    int rowCount(const QModelIndex& parent) const;
    int columnCount(const QModelIndex& parent) const;
    QVariant data(const QModelIndex& index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    Qt::ItemFlags flags(const QModelIndex& index) const;
    bool setData (const QModelIndex& index, const QVariant& value, int role = Qt::EditRole);
    void clear();

    void toggleSelect(QModelIndex index);
    void selectAll(bool select);
    bool removeRows(int row, int count, const QModelIndex &parent = QModelIndex());
    QList<Contact*> getSelected();
    Contact* getContact(QModelIndex index);
    int search(QTableView* tableView, QString text);

private:
    QList<Contact*>* m_Contacts;
    QPixmap m_defaultImage;
    QString m_Highlight;
};
#endif // CONTACTSDATAMODEL_H
