//======================================================================
//  stdout-to-textview.c
//
//  An example how to place stdout from a an external process
//  into a text view buffer by running the process in a separate
//  thread.
//
//  This program is released under the LGPL v3.0.
//
//  Dov Grobgeld <dov.grobgeld@gmail.com>
//  Fri Nov 20 09:22:39 2009
//----------------------------------------------------------------------
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#if 0
int
main(int argc, char *argv[])
{
    int      master_fd, slave_fd;
    FILE    *master_file, *slave_file;
    char     buf[80], *device;

    master_fd = posix_openpt(O_RDWR | O_NOCTTY);

    grantpt(master_fd);
    unlockpt(master_fd);

    slave_fd = open(device = ptsname(master_fd), O_RDWR | O_NOCTTY);

    printf("slave device: %s\n", device);

    master_file = fdopen(master_fd, "r");
    slave_file = fdopen(slave_fd, "w+");

    if (fork()) {
        fclose(slave_file);
        while (fgets(buf, sizeof(buf), master_file))
            printf("parent got: %s", buf);

    } else {
        // child
        fclose(master_file);
        for (int i = 0; i < 500; i++) {
            sleep(1);
            fprintf(slave_file, "child's data (%d)\n", i);
        }
    }

    return 0;
}
#endif

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

// This structure contains all the thread info for the job.
typedef struct {
  GMutex *update_mutex;
  GCond *update_cond;
  GMutex *mutex_to_run;
  
  gchar *cmd;
  gchar *info;
}  JobData;

// Sorry, out of laziness I made the widgets global.
GtkWidget *w_text_view = NULL;
GtkWidget *w_entry_cmd = NULL;
GMutex *mutex_one_job_at_a_time = NULL;

// Create the data for a job
JobData *job_data_new(const char *cmd,
                      GMutex *mutex_to_run)
{
  JobData *job_data = g_new0(JobData, 1);
  
  job_data->cmd = g_strdup(cmd);
  job_data->update_mutex = g_mutex_new();
  job_data->update_cond = g_cond_new();
  job_data->mutex_to_run = mutex_to_run;
  
  return job_data;
}

// free the data from a job
void job_data_free(JobData *job_data)
{
  g_free(job_data->cmd);
  g_mutex_free(job_data->update_mutex);
  g_cond_free(job_data->update_cond);
  g_free(job_data);
}


// This function receives a requst from a worker thread asking to
// update the gui with the required info.
gboolean cb_update_job(JobData *job_data)
{
  if (job_data->info) {
    GtkTextBuffer *text_buffer =
      gtk_text_view_get_buffer(GTK_TEXT_VIEW(w_text_view));
    GtkTextIter end_iter;
    gtk_text_buffer_get_end_iter(text_buffer,
				 &end_iter);
    gtk_text_buffer_insert(text_buffer,
			   &end_iter,
			   job_data->info,
			   -1);
    gtk_text_view_scroll_to_iter (GTK_TEXT_VIEW(w_text_view),
				  &end_iter, 0.0, TRUE, 0.0, 0.5);
    g_free(job_data->info);
    job_data->info = NULL;
  }
  
  // Indicate that the update is done
  g_mutex_lock(job_data->update_mutex);
  g_cond_signal(job_data->update_cond);
  g_mutex_unlock(job_data->update_mutex);
  
  return FALSE;
}

// A helper function run in the job thread receiving the string that
// should be displayed in the textview.
void job_add_to_text_viewer(JobData *job_data,
                            const char *info)
{
  job_data->info = g_strdup(info);
  
  // Lock mutex to make sure that we will receive the condition signal
  g_mutex_lock(job_data->update_mutex);
  g_idle_add((GSourceFunc)cb_update_job, job_data);
  
  // Wait for cb_update_job to tell me that the update is done
  g_cond_wait(job_data->update_cond,
	      job_data->update_mutex);
  g_mutex_unlock(job_data->update_mutex);
}

// The thread entry point. It will do the job, send the data to the
// GUI and self destruct when it is done.
static gpointer thread_worker(JobData *job_data)
{
  FILE *fh = popen(job_data->cmd,"r");
  printf("thread_worker running %s\n", job_data->cmd);
  GIOStatus status;
  GError *error = NULL;
  gsize length;
  gsize terminator_pos;
  gchar *str_return;

  /* switch to line buffered mode */
  if(setvbuf(fh, NULL, _IOLBF, 0))
    perror("setvbuf(_IOLBF)");
  
  GIOChannel *gh = g_io_channel_unix_new(fileno(fh));

  while( (status = g_io_channel_read_line(gh,
					  &str_return,
                                            &length,
					  &terminator_pos,
					  &error)) == G_IO_STATUS_NORMAL)
    {
      job_add_to_text_viewer(job_data,
			     str_return);
      g_free(str_return);
    }
  
  g_io_channel_unref(gh);
  pclose(fh);
  job_add_to_text_viewer(job_data, "Job done!");
  
  g_mutex_unlock(job_data->mutex_to_run);
  g_thread_exit(NULL);
  if (job_data)
    job_data_free(job_data);
  
  return NULL;
}

// Callback for the run button
void cb_clicked_run(GtkWidget *widget,
                    gpointer  user_data)
{
  const gchar *cmd = gtk_entry_get_text(GTK_ENTRY(w_entry_cmd));
  GError *error = NULL;
  printf("Run %s\n", cmd);
  
    // create a thread that will run the external command
    // tbd...
  JobData *job_data = job_data_new(cmd, mutex_one_job_at_a_time);
  g_thread_create((GThreadFunc)thread_worker, job_data, FALSE, &error);
  if (error) {
    printf("%s\n", error->message);
    g_error_free(error);
  }
}

void create_gui()
{
  GtkWidget *w_top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  GtkWidget *w_vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(w_top), w_vbox);
  
  GtkWidget *w_scrolled_win = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_size_request(w_scrolled_win, 500, 400);
  gtk_box_pack_start(GTK_BOX(w_vbox), w_scrolled_win,
		     TRUE, TRUE, 0);
  w_text_view = gtk_text_view_new();
  gtk_container_add(GTK_CONTAINER(w_scrolled_win),
		    w_text_view);
  
  // An hbox with an entry for the command to run
  GtkWidget *w_hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(w_vbox), w_hbox,
		     FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(w_hbox), gtk_label_new("Command:"),
		     FALSE, FALSE, 0);
  w_entry_cmd = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(w_entry_cmd),
       /* "perl -e '$|++; for $i (0..10) { print \"$i\\n\";sleep 1 }'" */
		       "/usr/bin/geotoad --distanceMax=1 --output=/home/harbaum/scratchbox/navi/gpxview_examples/gtoad.gpx --password=winterblume --queryType=coord --user=Tantil 'N49 00.000 E008 23.000'"
		       );

    gtk_box_pack_start(GTK_BOX(w_hbox), w_entry_cmd,
                       TRUE, TRUE, 0);
    GtkWidget *w_button_run = gtk_button_new_with_label("Run");
    gtk_box_pack_start(GTK_BOX(w_hbox), w_button_run,
                       FALSE, FALSE, 0);
    g_signal_connect(w_button_run, "clicked",
                     G_CALLBACK(cb_clicked_run), NULL);
    
    // Finally quit button
    GtkWidget *w_button_quit = gtk_button_new_with_label("Quit");
    gtk_box_pack_start(GTK_BOX(w_vbox), w_button_quit,
                       FALSE, FALSE, 0);
    g_signal_connect(w_button_quit, "clicked",
                     G_CALLBACK(gtk_main_quit), NULL);
    
    
    gtk_widget_show_all(w_top);
}

int main(int argc, char **argv)
{
    // init threads
  g_thread_init(NULL);
  gtk_init(&argc, &argv);
  
  // Only allow running one command at a time
  mutex_one_job_at_a_time = g_mutex_new();
  
  create_gui();
  
  gtk_main();
  exit(0);
}
