#ifndef LATITUDEGUI_H
#define LATITUDEGUI_H

#include <QtGui/QWidget>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QButtonGroup>
#include <QtGui/QRadioButton>
#include <QtGui/QSlider>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QDesktopServices>
#include <QtCore/QProcess>
#include <QtCore/QCoreApplication>
#include <QtCore/QDir>
#include <QtCore/QFile>
#include "googlelatitude.h"
#include "gpscontrol.h"

class LatitudeGUI : public QWidget {
    Q_OBJECT
public:
    LatitudeGUI(QWidget *parent = 0);

signals:

public slots:

private slots:
    void gl_GotToken() {
        qDebug() << "* LatitudeGUI::gl_GotToken";
        do_oauth->setDisabled(true);
        if (system("killall -0 LatitudeUpdaterDaemon 2> /dev/null" )) {
            do_start->setEnabled(true);
            do_stop->setDisabled(true);
        } else {
            do_start->setDisabled(true);
            do_stop->setEnabled(true);
        }
    }
    void gl_NotToken() {
        qDebug() << "* LatitudeGUI::gl_NotToken";
        do_oauth->setEnabled(true);
        do_start->setDisabled(true);
        do_stop->setDisabled(true);
        gps.stopUpdates(true);
    }
    void gl_needAuth() {
        qDebug() << "* LatitudeGUI::gl_needAuth";
        do_oauth->setEnabled(true);
    }
    void gl_webauth() {
        qDebug() << "* LatitudeGUI::gl_webauth";
        QDesktopServices::openUrl(latitude.getUserAuthorization());
    }
    void gps_start() {
        qDebug() << "* LatitudeGUI::gps_start";
        do_start->setDisabled(true);
        do_stop->setEnabled(true);
        if (demonio.exists()) {
            qDebug() << "* LatitudeGUI:: demonio";
            cli.startDetached(demonio.fileName());
            return;
        }
        qDebug() << "* LatitudeGUI:: demonio none";
        gps.startUpdates();
    }
    void gps_stop() {
        qDebug() << "* LatitudeGUI::gps_stop";
        do_start->setEnabled(true);
        do_stop->setDisabled(true);
        if (demonio.exists()) {
            qDebug() << "* LatitudeGUI:: demonio kill" << system("killall LatitudeUpdaterDaemon 2> /dev/null");
        } else {
            gps.stopUpdates(true);
        }
    }
    void set_latitude() {
        qDebug() << "* LatitudeGUI::set_latitude";
        latitude.setCurrentLocation(gps.getCurrentLatitude(),
                                    gps.getCurrentLongitude(),
                                    gps.getCurrentAccuracy());
        latitude.sendCurrentLocation();
    }
    void set_method() {
        qDebug() << "* LatitudeGUI::set_method";
        if (gps_cell->isChecked()) gps.setPositioningMethod("cell");
        if (gps_both->isChecked()) gps.setPositioningMethod("all");
        if (gps_agps->isChecked()) gps.setPositioningMethod("gps");
    }
    void set_to(int value) {
        qDebug() << "* LatitudeGUI::set_to()" << value;
        gps.setTimeOut(value);
        gps_to_slider_value->setText(QString("%1 sec.").arg(value));

    }
    void set_i(int value) {
        qDebug() << "* LatitudeGUI::set_i()" << value;
        gps.setInterval(value*60);
        gps_i_slider_value->setText(QString("%1 min.").arg(value));
    }
    void set_ac_yes() {
        qDebug() << "* LatitudeGUI::set_ac_yes";
        latitude.setAutoConnect(true);
    }
    void set_ac_not() {
        qDebug() << "* LatitudeGUI::set_ac_not";
        latitude.setAutoConnect(false);
    }

private:
    GoogleLatitude latitude;
    GpsControl gps;
    QFile demonio;
    QProcess cli;

    QHBoxLayout *layout_row1;
    QPushButton *do_oauth;
    QPushButton *do_start;
    QPushButton *do_stop;

    QHBoxLayout *layout_row2;
    QLabel *gps_method;
    QButtonGroup *gps_group;
    QRadioButton *gps_cell;
    QRadioButton *gps_both;
    QRadioButton *gps_agps;

    QHBoxLayout *layout_row3;
    QLabel *gps_to_label;
    QSlider *gps_to_slider;
    QLabel *gps_to_slider_value;

    QHBoxLayout *layout_row4;
    QLabel *gps_i_label;
    QSlider *gps_i_slider;
    QLabel *gps_i_slider_value;

    QHBoxLayout *layout_row5;
    QLabel *gps_ac_label;
    QButtonGroup *gps_ac_group;
    QRadioButton *gps_ac_yes;
    QRadioButton *gps_ac_not;

    QVBoxLayout *layout_gui;
};

#endif // LATITUDEGUI_H

