#ifndef LatitudeQML_H
#define LatitudeQML_H

#include <QObject>
#include <QtDeclarative/QDeclarativeView>
#include <QtCore/QProcess>
#include <QtCore/QCoreApplication>
#include <QtCore/QDir>
#include <QtCore/QFile>
#include "googlelatitude.h"
#include "gpscontrol.h"

class LatitudeQML : public QDeclarativeView {
    Q_OBJECT
public:
    LatitudeQML(QDeclarativeView *parent = 0);

signals:

public slots:
    bool demonio_status() {
        qDebug() << "LatitudeQML::demonio_status";
        if (system("killall -0 LatitudeUpdaterDaemon 2> /dev/null" )) {
            return false;
        }
        return true;
    }
    bool demonio_start() {
        qDebug() << "LatitudeQML::demonio_start";
        if (demonio.exists()) {
            cli.startDetached(demonio.fileName());
            return true;
        }
        qDebug() << "LatitudeQML:: demonio none";
        return false;
    }
    bool demonio_stop() {
        qDebug() << "LatitudeQML::demonio_stop";
        if (demonio.exists()) {
            qDebug() << "LatitudeQML:: demonio kill" << system("killall LatitudeUpdaterDaemon 2> /dev/null");
            return true;
        }
        return false;
    }

private slots:

private:
    GoogleLatitude latitude;
    GpsControl gps;
    QFile demonio;
    QProcess cli;
};

#endif // LatitudeQML_H
