#ifndef LATITUDEDAEMON_H
#define LATITUDEDAEMON_H

#include <QObject>
#include <QtCore/QCoreApplication>
#include "googlelatitude.h"
#include "gpscontrol.h"

class LatitudeDaemon : public QObject {
    Q_OBJECT
public:
    LatitudeDaemon(QObject *parent = 0);
signals:

public slots:

private slots:
    void gl_GotToken() {
        qDebug() << "LatitudeDaemon::gl_GotToken()";
        gps.startUpdates();
    }
    void gl_NotToken() {
        qDebug() << "LatitudeDaemon::gl_NotToken()";
        QCoreApplication::exit();
    }
    void gl_needAuth() {
        qDebug() << "LatitudeDaemon::gl_needAuth()";
        QCoreApplication::exit();
    }
    void get_gps() {
        qDebug() << "LatitudeDaemon::get_gps()"
                 << gps.getCurrentLatitude()
                 << gps.getCurrentLongitude()
                 << gps.getCurrentAccuracy()
                 << gps.getCurrentTimestamp();
    }
    void set_latitude() {
        qDebug() << "LatitudeDaemon::set_latitude()"
                 << gps.getCurrentLatitude()
                 << gps.getCurrentLongitude()
                 << gps.getCurrentAccuracy()
                 << gps.getCurrentTimestamp();
        latitude.setCurrentLocation(gps.getCurrentLatitude(),
                                    gps.getCurrentLongitude(),
                                    gps.getCurrentAccuracy());
        latitude.sendCurrentLocation();
    }

private:
    GoogleLatitude latitude;
    GpsControl gps;
};

#endif // LATITUDEDAEMON_H
