#ifndef GLATITUDE_H
#define GLATITUDE_H

#include <QtNetwork>

class GoogleLatitude : public QObject {
    Q_OBJECT

signals:
    void OK();
    void ERROR();

public:
    GoogleLatitude(QObject *parent = 0);
    void login(QString username, QString password);
    void set(double latitude, double longitude, double accuracy=1000.);
    double get_lat() { return latitude; }
    double get_lon() { return longitude; }
    double get_acc() { return accuracy; }

private slots:
    void finishedreply(QNetworkReply *r);

private:
    // info
    QString user;
    QString pass;
    double latitude;
    double longitude;
    double accuracy;
    // stuff
    QNetworkAccessManager *worker;
    QUrl urllogin;
    QUrl urldologin;
    QUrl urlupdate;
};

#endif // GLATITUDE_H
