#ifndef LATITUDE_H
#define LATITUDE_H

#include <QtGui>
#include <QtWebKit>
#include "glatitude.h"
#include "gps.h"
#include "gpsfake.h"

class LatitudeGUI : public QMainWindow {
    Q_OBJECT

signals:
    void newpos();

public:
    LatitudeGUI(QMainWindow *parent = 0);

private slots:
    void get_loc();
    void get_acwp();
    void get_agnss();
    void get_maemo5();
    void set();
    void set_OK();
    void set_ERROR();
    void save();
    void show_map();
    void show_lat();
    void maps_login();

private:
    GoogleLatitude *glatitude;
    GpsMaemo5 *gps;
    QSettings *setting;
    QWebView *maps;
    QWidget *location;
    QUrl urllogin;

    QLineEdit *login_user;
    QLineEdit *login_pass;
    QLineEdit *location_lat;
    QLineEdit *location_lon;
    QLineEdit *location_acc;

    QLineEdit *status;
};

#endif // LATITUDE_H
