/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#include "itemlist.h"
#include "ui/itemdialog.h"
#include "data/gmwitemsortfilterproxymodel.h"

#include <QGridLayout>
#include <QTreeView>
#include <QTableView>
#include <QHeaderView>
#include <QDebug>
#include <QApplication>
#include <QPointer>

GMWObjectList::GMWObjectList(GMWItemSortFilterProxyModel *model, QWidget *parent) :
    QWidget(parent, Qt::Window),
    m_model(model)
{
    setWindowTitle("Get Me Wheels - " + tr("Vehicle list"));

    QGridLayout *layout = new QGridLayout(this);
    setLayout(layout);

    QTableView *tableView = new QTableView();
    tableView->setSortingEnabled(true);
    tableView->horizontalHeader()->setVisible(false);
    tableView->verticalHeader()->setVisible(false);
    connect(tableView, SIGNAL(clicked(const QModelIndex &)), this, SLOT(itemClicked(const QModelIndex &)));
    layout->addWidget(tableView);

    tableView->setModel(model);
    tableView->sortByColumn(2, Qt::AscendingOrder);

    tableView->horizontalHeader()->setResizeMode(0, QHeaderView::Stretch);
    tableView->horizontalHeader()->setResizeMode(1, QHeaderView::ResizeToContents);
    tableView->horizontalHeader()->setResizeMode(2, QHeaderView::ResizeToContents);

    tableView->verticalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    tableView->setSelectionBehavior(QAbstractItemView::SelectRows);
    tableView->setSelectionMode(QAbstractItemView::SingleSelection);

    tableView->setWordWrap(false);
}

void GMWObjectList::itemClicked(const QModelIndex &index)
{
    QPointer<ItemDialog> itemDialog = new ItemDialog(this);
    connect(itemDialog, SIGNAL(zoomTo(const QGeoCoordinate &)), this, SLOT(hide()));
    connect(itemDialog, SIGNAL(zoomTo(const QGeoCoordinate &)), this, SIGNAL(zoomTo(const QGeoCoordinate &)));
    connect(m_model, SIGNAL(layoutChanged()), itemDialog, SLOT(currentPositionChanged()));
    for(int i = 0; i < m_model->rowCount(); i++){
        if (!itemDialog) {
            // Dialog might be already closed (and deleted)
            qDebug() << "dialog already deleted";
            return;
        }
        itemDialog->addObject(m_model->data(m_model->index(i, 0), Qt::UserRole).value<GMWItem*>());
        if(index.row() == i) {
            itemDialog->show();
            itemDialog->goToPage(index.row());
        }
        QApplication::processEvents();
    }
}

