#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QModelIndex>
#include <QNetworkAccessManager>
#include <QTime>
#include <QFile>
#include <QDBusVariant>

namespace Ui
{
class MainWindow;
}
class RCQTextEdit;
class UsbManager;
class QTextEdit;
class HelpWindow;
class DeviceDiscoveryDialog;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    //QAction *newAct2;
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    QNetworkAccessManager manager;
    QNetworkReply *currentDownload;
    QTime downloadTime;
    QFile downfile;
    UsbManager *m_usbmanage;
    DeviceDiscoveryDialog *m_btdevice;
    QTextEdit *m_helpwindow;
    QStringList hfiles;
    QColor bgtextcolor;
    QColor textcolor;
    QString btclientadr;
    QString btclientservice;
    bool btclientconstatus;

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void appendhostfile(QString filename);
    void downloadProgress(qint64 bytesReceived, qint64 bytesTotal);
    void downloadFinished();
    void downloadReadyRead();
    void save_ini();
    void load_ini();
    void wload_ini();
    void btload_ini();
    void usbload_ini();
    void checkbootfile();
    void on_pushButton_rulenow_clicked();
    void on_listWidget_real_doubleClicked(QModelIndex index);
    int runtime_filter(QString);
    void refresh_filter();
    void showresolv();
    void on_pushButton_adddns_clicked();
    void on_pushButton_routedefaultadd_clicked();
    void on_pushButton_gweadd_clicked();
    void on_pushButton_ruledropall_clicked();
    void on_checkBox_outloop_clicked(bool checked);
    void on_pushButton_outportclear_clicked();
    void on_pushButton_outportsave_clicked();
    void on_pushButton_outportrm_clicked();
    void on_pushButton_outportload_clicked();
    void on_pushButton_outportadd_clicked();
    void on_checkBox_output_clicked(bool checked);
    void on_pushButton_optmore_clicked();
    void on_pushButton_outportmore_clicked();
    void on_tabWidget_for_currentChanged(int index);
    void on_tabWidget_local_currentChanged(int index);
    void on_checkBox_icmp_stateChanged(int );
    void on_checkBox_filteroutput_stateChanged(int );
    void on_pushButton_rulefire_clicked();
    void on_pushButton_ruledrop_clicked();
    void on_pushButton_goextra_clicked();
    void on_pushButton_gomain_clicked();
    void on_pushButton_ruleaccept_clicked();
    void on_listWidget_log_doubleClicked(QModelIndex index);
    void getcontext_signal(int);
    void on_pushButton_stopklogd_clicked();
    void on_pushButton_startklogd_clicked();
    void on_pushButton_rmsyslog_clicked();
    void on_pushButton_stopsysd_clicked();
    void on_pushButton_startsysd_clicked();
    void on_pushButton_loadlog_clicked();
    void on_tabWidget_rules_currentChanged(int index);
    void on_pushButton_clearfport_clicked();
    void on_pushButton_loportclear_clicked();
    void on_pushButton_clearrules_clicked();
    void on_pushButton_loadrules_clicked();
    void on_pushButton_saverules_clicked();
    void on_pushButton_editrule_clicked();
    void on_pushButton_rmrule_clicked();
    void on_pushButton_addrule_clicked();
    void on_pushButton_loadfport_clicked();
    void on_pushButton_savefport_clicked();
    void on_pushButton_loadloport_clicked();
    void on_pushButton_saveloport_clicked();
    void checkwmode();
    void checkbtmode();
    void wifistatus();
    bool checkmodule(QString nmodule);
    bool checkini(QString inifile,QString inigroup);
    bool checkdnsmasq();
    bool getBTstatus();
    bool getforward(bool setcolor);
    int cuttercount(QString row);
    int cutterint(QString row, QString sterm, int place);
    QString getBTcon();
    QString getBTproperty(QString key);
    QString getBTdevPath();
    QString getBTadapterPath(QString address);
    QString getlsof();
    QString write_filter(QString);
    QString filterlog(QString linelog);
    QString cutter(QString row, QString cutstr, int place);
    QString getip(QString dev);
    QString getleaseip(QString macadd);
    void showleaseip(QString macadd);
    void showconnections();
    QString cutsubnet(QString net);
    bool wmode(QString dev);
    QString getfilter(QString ftype);
    QString getpidof(QString pname);
    void sshstatus();
    void sshinfo();
    void getrev();
    void getimei();
    void getimsi();
    void getpower();
    void getos();
    void getkernel();
    void deleteSettings(QString);
    void on_tabWidget_route_currentChanged(int index);
    void on_pushButton_ipinfo_clicked();
    void on_checkBox_sship_clicked(bool checked);
    void on_radioButton_masqlan_clicked(bool checked);
    void on_radioButton_masqsub_clicked(bool checked);
    void on_checkBox_forward_stateChanged(int );
    void on_pushButton_rmfport_clicked();
    void on_pushButton_addfport_clicked();
    void on_pushButton_loportdel_clicked();
    void on_pushButton_addloport_clicked();
    void on_pushButton_gen_clicked();
    void on_pushButton_stop_clicked();
    void on_pushButton_start_clicked();
    void write_wall();
    void on_pushButton_loaddnow_clicked();
    void on_pushButton_saveini_clicked();
    void on_pushButton_loadini_clicked();
    void on_pushButton_deleteset_clicked();
    void on_pushButton_gwdel_clicked();
    void on_pushButton_routedefaultdel_clicked();
    void on_pushButton_resetdns_clicked();
    void on_pushButton_wsave_clicked();
    void on_pushButton_wstartstop_clicked();
    void on_pushButton_wadhoc_clicked();
    void on_pushButton_sshstartstop_clicked();
    void on_pushButton_btsave_clicked();
    void on_pushButton_btonoff_clicked();
    void on_pushButton_btstart_clicked();
    void on_pushButton_delboot_clicked();
    void on_pushButton_addblackip_clicked();
    void on_pushButton_rmblackip_clicked();
    void on_pushButton_clblackip_clicked();
    void on_pushButton_loadblackip_clicked();
    void on_pushButton_saveblackip_clicked();
    void on_pushButton_addblackip_out_clicked();
    void on_pushButton_rmblackip_out_clicked();
    void on_pushButton_clblackip_out_clicked();
    void on_pushButton_loadblackip_out_clicked();
    void on_pushButton_saveblackip_out_clicked();
    void on_pushButton_addnowblackip_out_clicked();
    void on_checkBox_blacklist_stateChanged(int state);
    void on_checkBox_blacklist_out_stateChanged(int state);
    void on_checkBox_lom_clicked();
    void on_checkBox_lolan_clicked();
    void on_pushButton_addnowblackip_clicked();
    void on_pushButton_bldnsmasq_clicked();
    void on_pushButton_addbldomain_clicked();
    void on_pushButton_rmbldomain_clicked();
    void on_pushButton_clbldomain_clicked();
    void on_pushButton_loadbldomain_clicked();
    void on_pushButton_savebldomain_clicked();
    void on_pushButton_bldnsmasq_restart_clicked();
    void on_pushButton_loadfile_clicked();
    void on_pushButton_blhostappend_clicked();
    void on_pushButton_blhostdown_clicked();
    void on_pushButton_sshkillpid_clicked();
    void on_checkBox_btdiscover_stateChanged(int state);
    void on_pushButton_bridge_clicked();
    void on_pushButton_btstop_clicked();
    void on_pushButton_usblmodule_clicked();

    void on_pushButton_usbsave_clicked();
    void on_pushButton_usbstart_clicked();
    void on_pushButton_usbstop_clicked();

    void dnsmasqinfo();

    void on_pushButton_dnsmasq_restart_clicked();
    void on_pushButton_dnskillpid_clicked();
    void on_pushButton_dnsmasq_clicked();
    void on_pushButton_forward_clicked();
    void on_tabWidget_main_currentChanged(int index);
    void on_pushButton_help_clicked();
    void showHelp(QString infofile);
    void on_pushButton_helpaktion_clicked();
    void on_listWidget_help_doubleClicked(const QModelIndex &index);

    void on_pushButton_loadfileblip_clicked();
    void on_pushButton_advset_clicked();
    void on_checkBox_fontfilter_stateChanged(int arg1);
    void on_pushButton_bgcolor_clicked();
    void on_pushButton_viewfontcolor_clicked();
    void textcolorset(QColor);
    void bgtextcolorset(QColor);
    void dhcp_client();

    void on_pushButton_clients_clicked();

    void on_comboBox_resolv_currentIndexChanged(const QString &arg1);

    void on_pushButton_btsearch_clicked();

    void on_pushButton_dhclient_clicked();
    void checkConnection(QString name, QDBusVariant value);

    void on_pushButton_btclose_clicked();

public slots:
    void helpaktion_button(bool act, bool forground);
    void bt_connect(QString btaddress, QString btservice);
    void bt_trust(QString btaddress);

signals:
    void refresh_trust(QString btaddress);

};

#endif // MAINWINDOW_H
