#include "usbmanager.h"
#include "ui_usbmanager.h"
#include "processrunner.h"

static const QString script("/opt/genwall/usbmodule.sh");

UsbManager::UsbManager(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::UsbManager)
{
    ui->setupUi(this);
    m_runner = new ProcessRunner;
    connect(m_runner, SIGNAL(finished(int)),this, SLOT(dataAvailable(int)));


    m_conf_usb_iface = false;
    m_runner->start(script, QStringList("status"));
}

UsbManager::~UsbManager()
{
    delete ui;
}

void UsbManager::refresh()
{
    m_runner->start(script, QStringList("status"));
}
void
UsbManager::load_g_ether(void)
{
    QStringList args("g_ether");
    ui->label_usbmstat->setText("loading...");
    m_runner->start(script, args);
    m_conf_usb_iface = true;
}

void
UsbManager::load_g_nokia(void)
{
    QStringList args("g_nokia");
    ui->label_usbmstat->setText("loading...");
    m_runner->start(script, args);
    m_conf_usb_iface = true;
}

void
UsbManager::load_g_file_storage(void)
{
    QStringList args("g_file_storage");
    ui->label_usbmstat->setText("loading...");
    m_runner->start(script, args);
    m_conf_usb_iface = false;
}

void
UsbManager::dataAvailable(int exitCode)
{
    QByteArray out;
    if (exitCode != 0) {
        out = m_runner->getStderr();
        ui->label_usbmstat->setText("None");
    } else {
        out = m_runner->getStdout();
        if (out.size() != 0) {
            ui->label_usbmstat->setText(out.trimmed());
        }
    }
    emit done(!exitCode && m_conf_usb_iface);
}
void UsbManager::on_pushButton_usbmwin_clicked()
{
    load_g_ether();
}

void UsbManager::on_pushButton_usbmlin_clicked()
{
    load_g_nokia();
}

void UsbManager::on_pushButton_usbmstor_clicked()
{
    load_g_file_storage();
}
