/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SEARCHDLG_H
#define SEARCHDLG_H

#include <QDialog>
#include <QNetworkAccessManager>

#include <QScriptEngine>
#include <QScriptEngineDebugger>
#include <QList>
#include <QModelIndex>

// #include "business.h"
#include "localsearchmodel.h"

namespace Ui {
    class SearchDlg;
}

class LocalSearchItemDelegate;

class SearchDlg : public QDialog
{
    Q_OBJECT

public:
    explicit SearchDlg(QNetworkAccessManager *pNetAccessMngr, QWidget *parent = 0);
    ~SearchDlg();

    Business selectedBusiness();

private:
    void search();

public:
    LocalSearchModel m_model;
    QString m_latLongStr;
    bool    m_hasChanged;
    // QList<Business> m_business;

private:
    Ui::SearchDlg *ui;
    QNetworkAccessManager *m_pNetAccessMngr;
    QNetworkReply *m_pReply;
    LocalSearchItemDelegate *m_pItemDelegate;

    QScriptEngine m_engine;
    // QScriptEngineDebugger m_debugger;
    int m_selectedIndex;

private slots:
    void on_queryEdit_textChanged(QString );
    void on_listView_clicked(QModelIndex index);
    void on_listView_doubleClicked(QModelIndex index);
    void on_searchBtt_clicked();
    void onFinished();
};

#endif // SEARCHDLG_H
