/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LOCATION_H
#define LOCATION_H

#include <QString>

class Location {
public:
    Location(QString desc, double lat, double longitude) {
        m_description = desc;
        m_latitude = lat;
        m_longitude = longitude;
    }

    Location() {}

    QString latitudeStr() const { return QString::number(m_latitude, 'g', 10); }
    QString longitudeStr() const { return QString::number(m_longitude, 'g', 10); }

public:
   virtual double latitude() const { return m_latitude; }
   virtual double longitude() const {return m_longitude; }
   virtual QString description() const { return m_description; }
   virtual void setDescription(QString value) { m_description = value;}
   virtual void setCoordinates(double latitude, double longitude) {
       m_latitude = latitude;
       m_longitude = longitude;
   }
   virtual bool operator==(const Location& other) {
       return m_latitude==other.m_latitude && m_longitude==other.m_longitude;
   }

protected:
   double m_latitude;
   double m_longitude;
   QString m_description;
};

#endif // LOCATION_H
