#!/usr/bin/env python
import sys
import os
import cPickle

from gargoyle_launcher_gui import *

CURRENTVERSION = "0.1.3"

class GLaunch(QtGui.QMainWindow):
    games_dict = {}

    def __init__(self, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.closeOnExit = True
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.setup_settings()
        #connect buttons
        QtCore.QObject.connect(self.ui.pushButtonAddGame, QtCore.SIGNAL('clicked()'), self.doAddGame)
        QtCore.QObject.connect(self.ui.pushButtonDelete, QtCore.SIGNAL('clicked()'), self.doDelGame)
        QtCore.QObject.connect(self.ui.pushButtonLaunch, QtCore.SIGNAL('clicked()'), self.doLaunch)

        QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.showAbout)
        self.load_settings()
        

    def doLaunch(self):
        os.system("cd /home/user/MyDocs/ && /usr/bin/gargoyle \"" 
                    + str(self.games_dict[self.ui.listWidgetGames.item(self.ui.listWidgetGames.currentRow()).text()]) 
                    + "\" &")

        if(self.closeOnExit):
            self.close()


    def doAddGame(self):
        self.fileName = QtGui.QFileDialog.getOpenFileName(self, "Open", self.lastpath, "All Files (*)")
        if( self.fileName ):         
            self.lastpath = self.fileName
            self.baseName = QtCore.QFileInfo(self.fileName).baseName()

            if not self.baseName in self.games_dict:
                self.games_dict[self.baseName] = self.fileName
                self.ui.listWidgetGames.addItem(self.baseName)

    def doDelGame(self):
        del self.games_dict[self.ui.listWidgetGames.item(self.ui.listWidgetGames.currentRow()).text()]
        self.ui.listWidgetGames.takeItem(self.ui.listWidgetGames.currentRow())

    def setup_settings(self):
        settings = QtCore.QSettings()
        QtCore.QCoreApplication.setOrganizationName('gman.me.uk')
        QtCore.QCoreApplication.setOrganizationDomain('gman.me.uk')
        QtCore.QCoreApplication.setApplicationName('Gargoyle Launcher')
        self.settings = settings

    def load_settings(self):
        try:
            self.lastpath = str(self.settings.value("last_path").toString())

            self.games_dict = cPickle.loads(str(self.settings.value("games_dict").toString()))
            for names in self.games_dict:
                 self.ui.listWidgetGames.addItem(names)
            

        except:
            print "firstRun... no Savefile found"
            self.lastpath = "/home/user/MyDocs/.documents/"


    def closeEvent(self, event):
        print "closing"        
        self.settings.setValue("last_path", self.lastpath)
        
        saveData = cPickle.dumps(self.games_dict)
        self.settings.setValue("games_dict", saveData)

    def showAbout(self):
        aboutString = "Gargoyle Launcher: v" + CURRENTVERSION + "\nGirish Gopi (maemo@gman.me.uk)\nSimple Gui to act as a frontend for Gargoyle, the Interactive Fiction Player (http://ccxvii.net/gargoyle/)\nMany thanks to tkatchev for the Gargoyle port"
        QtGui.QMessageBox.information(self, "About Gargoyle Launch", aboutString)


if __name__ == "__main__":
    #This function means this was run directly, not called from another python file.

    # We instantiate a QApplication passing the arguments of the script to it:
    app = QtGui.QApplication(sys.argv)

    glaunch = GLaunch()
    glaunch.show()

    # Now we can start it.
    sys.exit(app.exec_())

