#include "imagecache.h"
#include <QFileInfo>
#include <QUrl>
#include <QNetworkAccessManager>
#include <QEventLoop>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QDir>
#include <QDebug>

ImageCache::ImageCache(QObject *parent) :
    QObject(parent)
{
    imagecachefolder = QString("/home/user/.fourcircle/images/cache/");
    imagetempfolder = QString("/home/user/.fourcircle/images/temp/");
    QDir f(imagecachefolder);
    if(!f.exists())
        f.mkpath(imagecachefolder);

    f.setPath(imagetempfolder);
    if(!f.exists())
        f.mkpath(imagetempfolder);

}

QString ImageCache::getImage(QString url, bool cacheImage)
{
    if(url=="")
        return "";
    QByteArray source = url.toUtf8();
    quint16 sum = qChecksum(source.data(), source.length());
    QString str = QString::number(sum);
    QString filepath("");
    if(cacheImage)
        filepath.append(imagecachefolder);
    else
        filepath.append(imagetempfolder);

    filepath.append(str);

    QFileInfo fi(filepath);

    if(fi.exists() && cacheImage)
    {
        //qDebug() << "Cache hit for "+filepath;
        return fi.absoluteFilePath();
    }
    else
    {
        qDebug() << "Cache miss for "+filepath;
        if (this->downloadFile(url,fi.absoluteFilePath()))
            return fi.absoluteFilePath();
    }
    return "";
}

bool ImageCache::downloadFile(QString url, QString destPath)
{
    QNetworkAccessManager * testnam = new QNetworkAccessManager(this);
    //qDebug() << "url: "+url;
    QUrl a(url);
    QNetworkReply * reply = testnam->get(QNetworkRequest(a));
    // execute an event loop to process the request (nearly-synchronous)
    QEventLoop eventLoop;
    // also dispose the event loop after the reply has arrived
    connect(testnam, SIGNAL(finished(QNetworkReply *)), &eventLoop, SLOT(quit()));
    eventLoop.exec();
    qDebug() << "Downloaded";
    if (reply->error() == QNetworkReply::NoError)
    {
        QByteArray result = reply->readAll();  // bytes
        QFile f(destPath);
        f.open(QIODevice::Truncate | QIODevice::ReadWrite);
        f.write(result);
        f.close();
        qDebug() << "Saved";
        return true;
    }
    qDebug() << "Download failed";
    return false;
}
