/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */

#include <QtGui/QApplication>
#include "qmlapplicationviewer.h"
#include "qpdfimage.h"
#include "sethist.h"
#include "qappintentactivity.h"
#include <QtGui/QImage>
#include <QtGui/QPixmap>
#include <QtGui/QLabel>
#include <QDeclarativeImageProvider>
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include <QDir>
#include <QSettings>
#include <QDebug>
#include <QVariant>

SetHist *sethist;

#ifdef Q_WS_MAEMO_5
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
inline void grabVolKeys(WId wid){
	if (!wid)
		return;
	
	Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
	if (!atom)
		return;
	
	unsigned long data = 1;
	XChangeProperty (QX11Info::display(),wid,atom,
		XA_INTEGER,32,PropModeReplace,
		reinterpret_cast<unsigned char *>(&data),1);
}
#endif //Q_WS_MAEMO_5

#ifdef Q_OS_ANDROID
#include <jni.h>
JavaVM* jvm = NULL;
jobject qtactivity;
#define JNOTOKRETURN(WHAT) if(!WHAT || jenv->ExceptionCheck()){SetHist::log("WHAT went wrong");jenv->ExceptionClear();return JNI_VERSION_1_4;}
//not used now, see sethist.cpp
// Q_DECL_EXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void*){
// 	jvm = vm;
// 	JNIEnv *jenv;
// 	jvm->AttachCurrentThread(&jenv, NULL);
// 	jclass qtactivity_cls = jenv->FindClass("org/kde/necessitas/origo/QtActivity");
// 	JNOTOKRETURN(qtactivity_cls)
// 
//         jmethodID qtactivity_ctr = jenv->GetMethodID(qtactivity_cls, "<init>", "()V");
// 	JNOTOKRETURN(qtactivity_ctr)
// 
//         jobject loc = jenv->NewObject(qtactivity_cls, qtactivity_ctr);
// 	JNOTOKRETURN(loc)
//         qtactivity = jenv->NewGlobalRef(loc);
// 	JNOTOKRETURN(qtactivity)
// 
// 	return JNI_VERSION_1_4;
// }
#endif

Q_DECL_EXPORT int main(int argc, char *argv[]){
	qmlRegisterType<QPdfImage>("flatboat.PdfImage", 1, 0, "PdfImage");
	
	QScopedPointer<QAppIntentActivity> app(new QAppIntentActivity(argc, argv));
	QScopedPointer<QmlApplicationViewer> viewer(QmlApplicationViewer::create());
	app->setOrganizationName("flatboat");
	app->setApplicationName("flatboat");
	
// #ifdef Q_OS_ANDROID
// 	QFont stdfont = app->font(); 
// 	stdfont.setPointSize(12);
// 	app->setFont(stdfont);
// #endif //Q_OS_ANDROID

#ifdef Q_OS_MAC
	QDir dir(QApplication::applicationDirPath());
	dir.cdUp();
	dir.cd("plugins");
	QApplication::setLibraryPaths(QStringList(dir.absolutePath()));
#endif
	
	sethist = new SetHist();


#ifndef Q_OS_ANDROID
	//since necessitas alpha 4 we get an argument
	//TODO:figure out what it contains
	QStringList args = app->arguments();
	if(args.length() >= 2){
		QString fn = QUrl(args[1]).scheme() == "file" ? QUrl(args[1]).toLocalFile() : args[1];
		QVariantMap doc;
		doc["filepath"] = fn;
		sethist->newDocument(doc);
	}
#endif //NOT Q_OS_ANDROID
	
	
	viewer->setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
	viewer->rootContext()->setContextProperty("sethist", sethist);
	viewer->setSource(QUrl(QLatin1String("qrc:/main.qml")));
	
	QObject::connect((*viewer).rootObject(), SIGNAL(showFullScreen()),
			 viewer.data(), SLOT(showFullScreen()));
	QObject::connect((*viewer).rootObject(), SIGNAL(showNormal()),
			 viewer.data(), SLOT(showNormal()));
	QObject::connect(app.data(), SIGNAL(fileOpen(QString)),
			 (*viewer).rootObject(), SIGNAL(fileOpen(QString)));
	QObject::connect((*viewer).rootObject(), SIGNAL(windowTitleChangeRequest(QString)),
			 viewer.data(), SLOT(setWindowTitle(QString)));
	
	//alternative solution: set an allConnected property or similar
	viewer->setWindowTitle((*viewer).rootObject()->property("windowTitle").toString());
	viewer->showExpanded();
	viewer->setWindowIcon(QPixmap::fromImage(QImage(":/flatboat.png")).scaled(32,32));
	
	sethist->setWindowWidget(viewer.data());
	
#ifdef Q_WS_MAEMO_5
	grabVolKeys(viewer->winId());
#endif //Q_WS_MAEMO_5
	
	return app->exec();
}
