#include <QtGui/QApplication>
#include "mainwindow.h"
#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif
#include <QFile>
#include <QTranslator>

#include <QLocale>

QString langPath;

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    langPath = "/opt/filebox/lang/";

    //QString lang = QLocale::languageToString(QLocale::system().language());


    QString line, lang;
    QFile data( "/etc/osso-af-init/locale" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
        QTextStream out(&data);
        while ( !out.atEnd() )
        {
            line = out.readLine();
            if ( line.indexOf("export LANG") == 0 )
            {
                lang = line;
                lang.replace("export LANG=","");
            }
        }
    }
    //lang = "es_ES";
    data.close();

    QLocale::setDefault(lang);
    lang = QLocale::languageToString(QLocale(lang).language());

    QTranslator translator;
    if (!lang.isEmpty() && !langPath.isEmpty())
    {
        if (QFile::exists(langPath + lang + ".qm"))
        {
            translator.load(langPath + lang);
            a.installTranslator(&translator);
        }
    }

    QString folder(argv[1]);
    MainWindow* w = new MainWindow(0,folder);

    //w.setAttribute(Qt::WA_Maemo5AutoOrientation, true);

#if defined(Q_WS_S60)
    w->showMaximized();
#else
    w->show();
#endif
    return a.exec();
}
