#include <QDirModel>
#include <QPainter>
#include <QDebug>

#include "filedelegate.h"

FileDelegate::FileDelegate(QObject *parent)
    : QAbstractItemDelegate(parent)
{
}

void FileDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,
                          const QModelIndex &index) const
{
    const QDirModel *model = qobject_cast<const QDirModel *>(index.model());
    QPixmap pixmap(model->filePath(index));
    painter->drawPixmap(option.rect, pixmap);
}

QSize FileDelegate::sizeHint(const QStyleOptionViewItem &option,
                              const QModelIndex &index) const
{
    Q_UNUSED(option);

    const QDirModel *model = qobject_cast<const QDirModel *>(index.model());
    QImage image(model->filePath(index));
    return image.size();
}
