import Qt 4.7

Rectangle {
    id: addFeed;
    width: 500 //parent.width
    height: 172
    color: "white"
    property alias feedName: feedName.text
    property string catid
    property string feedUrl: feedURL.text
    //property boolean feedEdit: false;

    MouseArea { anchors.fill: parent; onClicked: {} }
    Column {
        Row {
            width: addFeed.width
            height: 86;
            Text { anchors.verticalCenter: parent.verticalCenter; text: qsTr("Feed name:") }
            LineInput{
                id: feedName
                anchors.centerIn: parent
                width: 140
                focus: true
            }
        }
        Row {
            width: addFeed.width
            height: 86;
            Text { anchors.verticalCenter: parent.verticalCenter; text: qsTr("Feed URL:") }
            LineInput{
                id: feedURL
                anchors.centerIn: parent
                width: 140
                focus: true
                text: "http://"
            }
        }
        Row {
            width: addFeed.width
            Button {
                id: ok
                text: qsTr("OK")
                anchors.margins: 5; y: 3; width: 80; height: 60
                onClicked: container.addFeed(catid, feedName.text, feedURL.text)
            }
            Button {
                id: cancel
                text: qsTr("Cancel")
                anchors.margins: 5; y: 3; width: 80; height: 60
                onClicked: addFeed.visible=false;
            }
        }
    }
}
