/*
 * Copyright (C) 2004-2010 Geometer Plus <contact@geometerplus.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __SCROLLINGTAB_H__
#define __SCROLLINGTAB_H__

class MovementToleranceEntry : public ZLComboOptionEntry {

public:
	MovementToleranceEntry(const ZLResource &resource, ZLIntegerOption &sensitivityOption);
	const std::string &initialValue() const;

	enum Position {
		POS_STYLUS = 0,
		POS_FINGER = 1
	};

	enum Tolerance {
		STYLUS = 5,
		FINGER = 20
	};

private:
	const std::vector<std::string> &values() const;
	void onAccept(const std::string &value);
	Tolerance positionToTolerance(Position position) const;
	Position toleranceToPosition(Tolerance tolerance) const;

private:
	std::vector<std::string> myValues;
	ZLIntegerOption &myOption;
};

#endif /* __SCROLLINGTAB_H__ */
