/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef BUTTONSHIFT_H
#define BUTTONSHIFT_H

#include <QPushButton>

class ThreeStateButton : public QPushButton
{
    Q_OBJECT
public:
    explicit ThreeStateButton(QWidget *parent = 0);
    int getState();
    void setState(int nState);
    enum States{noCheck,singleCheck,doubleCheck};
    void setGraphicNoCheck(QString sFileName,QString sLabel);
    void setGraphicSingleCheck(QString sFileName, QString sLabel);
    void setGraphicDoubleCheck(QString sFileName, QString sLabel);
    QIcon m_icoNoCheck;
    QIcon m_icoDoubleCheck;
    QIcon m_icoSingleCheck;
    QString m_sNoCheckLabel;
    QString m_sSingleCheckLabel;
    QString m_sDoubleCheckLabel;

private:
    int m_nState;

signals:

public slots:
    void released();

};

#endif // ThreeStateButton_H
