/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include <QApplication>
#include <QDebug>
#include "busManagerServ.h"
#include "fastsmswidget.h"

bool m_logToFile = true;

void logHandler(QtMsgType type, const char *msg)
{
        QString txt;
        switch (type) {
        case QtDebugMsg:
                txt = QString("Debug: %1").arg(msg);
                break;
        case QtWarningMsg:
                txt = QString("Warning: %1").arg(msg);
        break;
        case QtCriticalMsg:
                txt = QString("Critical: %1").arg(msg);
        break;
        case QtFatalMsg:
                txt = QString("Fatal: %1").arg(msg);
                abort();
        }
        QFile outFile("/opt/fastsms/data/fastsms.log");
        if(m_logToFile && (!outFile.open(QIODevice::WriteOnly | QIODevice::Append)))
        {
            m_logToFile = false;
            qInstallMsgHandler(0);
            qWarning() << "Can't open log file";
        }
        else
        {
            QTextStream ts(&outFile);
            ts << txt << endl;
        }
}

int main(int argc, char *argv[])
{
    qInstallMsgHandler(logHandler);
    qDebug() << "started:" << argv[0];

    QApplication a(argc, argv);
    a.setAutoSipEnabled(false);
    a.setApplicationVersion(APP_VERSION);

    FastSMSWidget w;

    //Manage signals from DBUS
    new busManagerServ(&w);
    QDBusConnection connection = QDBusConnection::sessionBus();
    if ( !connection.registerService("it.rsc.fastsms") ) {
        qDebug() << "error registering service.";
        exit(-1);
    }
    if ( !connection.registerObject("/", &w) ) {
        qDebug() << "error registering object";
        exit(-1);
    }

#if not defined(Q_WS_MAEMO_5)
    w.show();
#endif

    return a.exec();
}



