/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef PACKAGE_H
#define PACKAGE_H

#include <QtCore>
#include "blacklistselect.h"

class AAptInterface;
class Repository;

class Package
{
public:
	enum operation { PkgOpNone, PkgOpInstallUpgrade, PkgOpRemove };

	// the order must match status filter strings
	enum packageStatus { PkgStatUnknown, PkgStatNotInstalled, PkgStatUpgradeable, PkgStatInstalled };

	Package(QByteArray name_, AAptInterface* apt_);
	~Package();
	inline void setName(QByteArray n_) { iName=n_; }
	inline void setMaemoDisplayName(QByteArray n_) { iMaemoDisplayName=n_; }
	inline void setInstalled(bool i_) { iIsInstalled=i_; }
	void setMarkedForOperation(operation op_);
	inline void setVersion(QByteArray v_) { iVersion=v_; }
	inline void setDescShort(QByteArray d_) { iDescriptionShort=d_; }
	inline void appendDescLong(QByteArray d_) { iDescriptionLong.append(d_); }
	inline void setSection(QByteArray s_) { iSection=s_; }
	inline void setSize(int i_) { iSize=i_; }
	inline void setInstalledSize(int i_) { iInstalledSize=i_; }
	inline void appendIconData(QByteArray d_) { iIconData.append(d_); }
	inline void addFullFileName(QString f_) { iFullFileNames.append(f_); }
	void updateStatus();
	inline void addRepository(Repository* r_) { iRepositories.append(r_); }
	inline void setDate(QDateTime d_) { iDate=d_; }
	inline void setBlacklisted(BlacklistSelect::blackList bl_) { iBlacklist=bl_; }
	inline void appendDepends(QByteArray line_) { iDepends << line_.split(','); }
	inline void appendConflicts(QByteArray line_) { iConflicts << line_.split(','); }
	inline void appendPreDepends(QByteArray line_) { iPreDepends << line_.split(','); }
	inline void appendProvides(QByteArray line_) { iProvides << line_.split(','); }
	inline void appendReplaces(QByteArray line_) { iReplaces << line_.split(','); }
	inline void appendBreaks(QByteArray line_) { iBreaks << line_.split(','); }
	inline void appendRecommends(QByteArray line_) { iRecommends << line_.split(','); }
	inline void appendSuggests(QByteArray line_) { iSuggests << line_.split(','); }
	inline void appendUpgradeDescription(QByteArray d_) { iUpgradeDescription.append(d_); }
	inline void setPinned(bool p_) { iPinned=p_; }

	void convertIcon();

	inline QString name() { return iName; }
	inline QString maemoDisplayName() { return QString::fromUtf8(iMaemoDisplayName); }
	QString displayName();
	inline bool isInstalled() { return iIsInstalled; }
	inline bool isMarkedForOperation() { return iMarkedForOperation; }
	inline operation markedOperation() { return iMarkedOperation; }
	inline QString version() { return iVersion; }
	inline QString descShort() { return QString::fromUtf8(iDescriptionShort); }
	inline QString descLong() { return QString::fromUtf8(iDescriptionLong); }
	inline QString section() { return iSection; }
	inline int size() { return iSize; }
	inline int installedSize() { return iInstalledSize; }
	inline QPixmap* icon() { return iIcon; }
	bool hasIconData();
	bool isUpgradeable();
	QString upgradeableVersion();
	Package* availablePackage();
	packageStatus status();
	QString fileName();
	inline QStringList fullFileNames() { return iFullFileNames; }
	inline QDateTime date() { return iDate; }
	inline QList<Repository*> repositories() { return iRepositories; }
	inline BlacklistSelect::blackList blacklisted() { return iBlacklist; }
	inline bool isBlacklisted() { if(iBlacklist==BlacklistSelect::BlacklistNone) return false; else return true; }
	inline QString upgradeDescription() { return QString::fromUtf8(iUpgradeDescription); }
	inline QList<QByteArray> depends() { return iDepends; }
	inline QList<QByteArray> conflicts() { return iConflicts; }
	inline QList<QByteArray> preDepends() { return iPreDepends; }
	inline QList<QByteArray> provides() { return iProvides; }
	inline QList<QByteArray> replaces() { return iReplaces; }
	inline QList<QByteArray> breaks() { return iBreaks; }
	inline QList<QByteArray> recommends() { return iRecommends; }
	inline QList<QByteArray> suggests() { return iSuggests; }
	inline bool isPinned() { return iPinned; }

	QStringList checkConflicts_RichText();

	static bool versionCompare(QString isNewer, QString compare);
	static QStringList toTrimmedRichTextList(QList<QByteArray> list_in);

private:

	static bool versionConflicts(QString conflictVer, QString operVer);

	AAptInterface* iAptInterface;

	QByteArray iName;
	QByteArray iMaemoDisplayName;
	bool iIsInstalled;
	bool iMarkedForOperation;
	packageStatus iPkgStatus;
	QByteArray iVersion;
	QByteArray iDescriptionShort;
	QByteArray iDescriptionLong;
	QByteArray iSection;
	int iSize;
	int iInstalledSize;
	operation iMarkedOperation;
	QStringList iFullFileNames;
	QDateTime iDate;
	QList<Repository*> iRepositories;
	BlacklistSelect::blackList iBlacklist;
	QByteArray iUpgradeDescription;

	QByteArray iIconData;
	QPixmap* iIcon;

	QList<QByteArray> iDepends;
	QList<QByteArray> iConflicts;
	QList<QByteArray> iPreDepends;
	QList<QByteArray> iProvides;
	QList<QByteArray> iReplaces;
	QList<QByteArray> iBreaks;
	QList<QByteArray> iRecommends;
	QList<QByteArray> iSuggests;

	bool iPinned;
};

#endif // PACKAGE_H
