import logging

import osso

from dwimd.util import osso_context


def inhibit_screen_blanking():
    """
    Inhibits screen blanking. This function must be called repeatedly as long
    as blanking must not take place.
    """

    devstate = osso.DeviceState(osso_context)
    devstate.display_blanking_pause()


def act(value):
    if value:
        logging.warning("Cannot directly lock the screen but only avoid that it locks.")
    else:
        inhibit_screen_blanking()

