import logging
import os
import sys


plugin_cache = {}

def reload_plugins():
    reload_plugins_for_module("dwimd", "configs")
    reload_plugins_for_module("dwimd", "sensors")
    reload_plugins_for_module("dwimd", "actions")
    try:
        import dwimd_plugins
    except ImportError:
        return
    reload_plugins_for_module("dwimd_plugins", "configs")
    reload_plugins_for_module("dwimd_plugins", "sensors")
    reload_plugins_for_module("dwimd_plugins", "actions")


# XXX add support for zip files
def reload_plugins_for_module(packagename, modulename):
    namespace = {}
    module = __import__(packagename + "." + modulename, globals(), {}, [""])
    plugin_path = os.path.dirname(module.__file__)
    pluginnames = [packagename + "." + modulename + "." +
                    os.path.splitext(os.path.basename(fname))[0]
                for fname in os.listdir(plugin_path)
                if fname.endswith(".py") and
                not fname == "__init__.py"]
    plugins = plugin_cache.setdefault(modulename, [])
    for pluginname in sorted(pluginnames):
        try:
            del sys.modules[pluginname]
        except KeyError:
            pass
        logging.debug("Loading plugin %r ..." % (pluginname, ))
        try:
            plugin = __import__(pluginname, globals(), {}, [""])
        except ImportError, err:
            logging.warning("Could not load module %r: %r" % (pluginname, err))
            continue
        plugins.append((pluginname.rsplit(".", 1)[1], plugin))


def add_plugin(klass, name, module): # for tests only
    plugin_cache[klass].append((name, module))


def del_plugin(klass, name):
    for num, (pname, _) in enumerate(plugin_cache[klass]):
        if name == pname:
            plugin_cache[klass].pop(num)
            return
    raise KeyError("Not found")


def get_plugin(klass, name):
    try:
        return [plugin for pname, plugin in plugin_cache[klass]
                if pname == name][0]
    except IndexError:
        return None

def get_pluginnames(klass):
    return [pname for pname, _ in plugin_cache[klass]]

def get_plugins(klass):
    return plugin_cache[klass]

def init_plugins_for_klass(klass):
    for name, plugin in plugin_cache[klass]:
        logging.debug("Initing plugin %r ..." % (name, ))
        getattr(plugin, "init", lambda: None)()

def init_plugins():
    for name in ("configs", "sensors", "actions"):
        init_plugins_for_klass(name)
