/*
 * Copyright (C) 2011 Thomas Zell <t.zell@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include <stdlib.h>
#include <stdio.h>

#include <pulse/simple.h>
#include <pulse/error.h>


pa_simple *s = NULL;
short *buf = NULL;
int bufsize, samplestoplay;
float samplerate = 44100.0;
float playtime   =     0.2;


void play_sound(int freq_l, int freq_h)
{
	int i, error;
	float t, amplitude;
	
	for (i = 0; i < samplestoplay; i++) {
		t = (float)i / samplestoplay * playtime;
		if (t < 0.1) {
			if (t < 0.001)
				amplitude = 16000.0 * t/0.001;
			else if (t > 0.099)
				amplitude = 16000.0 * (0.1 - t)/0.001;
			else
				amplitude = 16000.0;
			buf[i] = (short)(amplitude * (sin(freq_l * 6.2831853 * t) + sin(freq_h * 6.2831853 * t)));
		} else
			buf[i] = 0;
	}

	if (pa_simple_write(s, buf, (size_t) bufsize, &error) < 0) {
		fprintf(stderr, __FILE__": pa_simple_write() failed: %s\n", pa_strerror(error));
	}	
}

void parse_number(char *number)
{
	int i = 0, freq_l, freq_h;
	
	while (number[i] != 0)
	{
		switch(number[i])
		{
			case '1':
			case '2':
			case '3':
				freq_l = 697;
				break;
			case '4':
			case '5':
			case '6':
				freq_l = 770;
				break;
			case '7':
			case '8':
			case '9':
				freq_l = 852;
				break;
			case '*':
			case '0':
			case '#':
				freq_l = 941;
				break;
			default:
				freq_l = 0;
				break;
		} 
		switch(number[i])
		{
			case '1':
			case '4':
			case '7':
			case '*':
				freq_h = 1209;
				break;
			case '2':
			case '5':
			case '8':
			case '0':
				freq_h = 1336;
				break;
			case '3':
			case '6':
			case '9':
			case '#':
				freq_h = 1477;
				break;
			default:
				freq_h = 0;
		}
		play_sound(freq_l, freq_h);
		i++;
	}
}

void print_usage()
{
	printf("dtmf PHONE-NUMBER\n");
}

int main(int argc, char* argv[])
{
	pa_sample_spec ss;
	int error;

	if (argc != 2) {
		print_usage();
		return -1;
	}

	samplestoplay = (int)(playtime * samplerate);
	bufsize = samplestoplay * 2;
	if (!(buf = (short *)malloc(bufsize))) {
		fprintf(stderr, __FILE__": malloc() failed\n");
		goto finish;
	}
	
	ss.format = PA_SAMPLE_S16NE;
	ss.channels = 1;
	ss.rate = 44100;

	if (!(s = pa_simple_new(NULL, "dtmf_play", PA_STREAM_PLAYBACK, NULL, "dtmf",
		&ss, NULL, NULL, &error))) {
		fprintf(stderr, __FILE__": pa_simple_new() failed: %s\n", pa_strerror(error));
		goto finish;
	}

	parse_number(argv[1]);
	
	if (pa_simple_drain(s, &error) < 0) {
		fprintf(stderr, __FILE__": pa_simple_drain() failed: %s\n", pa_strerror(error));
	}

finish:
	
	if (s)
		pa_simple_free(s);
	if (buf)
		free(buf);
	
	return 0;
}

