#include "mainwindowmaemo.h"
#include "ui_mainwindowmaemo.h"
#include "dabout.h"

MainWindowMaemo::MainWindowMaemo(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindowMaemo)
{
    ui->setupUi(this);
    connect(QApplication::desktop(),SIGNAL(resized(int)),this,SLOT(reorderUI()));
    netAccessMan = new QNetworkAccessManager(this);
    connect(netAccessMan, SIGNAL(finished(QNetworkReply*)), this, SLOT(downloadFinished(QNetworkReply*)));
    reorderUI();
}

MainWindowMaemo::~MainWindowMaemo()
{
    delete ui;
}

void MainWindowMaemo::reorderUI(){
#ifdef Q_WS_MAEMO_5
    /*if (Qt::WA_Maemo5PortraitOrientation==QApplication){
	ui->GetKey->setText("");
    }*/
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
	     if (screenGeometry.width() > screenGeometry.height()){
		 //Landscape Mode
		 ui->btnSearch->setGeometry(640,0,161,71);
		 ui->edtExtras->setGeometry(247,1,393,80);
		 ui->edtExtrasDevel->setGeometry(247,173,393,80);
		 ui->edtExtrasTesting->setGeometry(247,87,393,80);
		 ui->edtTotal->setGeometry(247,259,393,80);
		 ui->edtPackage->setGeometry(107,1,533,70);

	     }
	     else{
		 //Portrait Mode
		 ui->btnSearch->setGeometry(305,420,161,71);
		 ui->edtExtras->setGeometry(247,1,220,80);
		 ui->edtExtrasDevel->setGeometry(247,173,220,80);
		 ui->edtExtrasTesting->setGeometry(247,87,220,80);
		 ui->edtTotal->setGeometry(247,259,220,80);
		 ui->edtPackage->setGeometry(107,1,353,70);
		 }

#endif
}

void MainWindowMaemo::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
	const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
	if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
	    qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
	    return;
	}
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
	attribute = static_cast<Qt::WidgetAttribute>(128);
	break;
    case ScreenOrientationLockLandscape:
	attribute = static_cast<Qt::WidgetAttribute>(129);
	break;
    default:
    case ScreenOrientationAuto:
	attribute = static_cast<Qt::WidgetAttribute>(130);
	break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
	attribute = Qt::WA_LockPortraitOrientation;
	break;
    case ScreenOrientationLockLandscape:
	attribute = Qt::WA_LockLandscapeOrientation;
	break;
    default:
    case ScreenOrientationAuto:
	attribute = Qt::WA_AutoOrientation;
	break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindowMaemo::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindowMaemo::on_btnSearch_clicked(
	)
{
    if (!ui->edtPackage->text().simplified().isEmpty()){
	download("http://maemo.dadablog.net/AppStats.php?package="+ui->edtPackage->text().simplified()+"&os=fremantle");

	movie = new QMovie(":/loading.gif");

	if (movie->isValid()){
	    ui->lblDownloading->setMovie(movie);
	    movie->start();
	}else{
	    ui->lblDownloading->setPixmap(QPixmap(":/loading.gif"));
	}
    }
}

void MainWindowMaemo::download(QString item){
    QUrl url(item);
    QNetworkRequest request(url);
    netAccessMan->get(request);
}


void MainWindowMaemo::downloadFinished(QNetworkReply *reply)
{
    if (reply->error() != QNetworkReply::NoError) {
	//qDebug() << "Error in" << reply->url() << ":" << reply->errorString();
	ui->edtPackage->setText("maemo.dadablog.net is not available");
	reply->deleteLater();
	return;
    }
    QVariant redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute);
    if (redir.isValid()) {
	QUrl url = redir.toUrl();
	//qDebug() << "must go to:" << url;
	if (url.isRelative()) {
	    url.setScheme(reply->url().scheme());
	    url.setEncodedHost(reply->url().encodedHost());
	}
	QNetworkRequest req(url);
	netAccessMan->get(req);
	reply->deleteLater();
	return;
    }
    //ui->edtPackage->setText("ContentType:" +reply->header(QNetworkRequest::ContentTypeHeader).toString());

    downloadedItem = reply->readAll();

    if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="text/xml"){
	QString link=downloadedItem;
    }else if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="text/html"){
	QString statistics=downloadedItem;

	int totalBegins=statistics.indexOf("<b>Total</b></td><td><b>")+24;
	int totalEnds=statistics.indexOf("</b></td></tr>",totalBegins)+14;
	ui->edtTotal->setText(statistics.mid(totalBegins,totalEnds-totalBegins-14));

	if (ui->edtTotal->text()!="0"){
	    int extrasBegins=statistics.indexOf("Maemo.org Extras Total</b></td><td><b>")+38;
	    int extrasEnds=statistics.indexOf("</b></td></tr>",extrasBegins)+14;
	    ui->edtExtras->setText(statistics.mid(extrasBegins,extrasEnds-extrasBegins-14));

	    int extrasTestingBegins=statistics.indexOf("Maemo.org Extras-Testing Total</b></td><td><b>")+46;
	    int extrasTestingEnds=statistics.indexOf("</b></td></tr>",extrasTestingBegins)+14;
	    ui->edtExtrasTesting->setText(statistics.mid(extrasTestingBegins,extrasTestingEnds-extrasTestingBegins-14));

	    int extrasDevelBegins=statistics.indexOf("Maemo.org Extras-Devel Total</b></td><td><b>")+44;
	    int extrasDevelEnds=statistics.indexOf("</b></td></tr>",extrasDevelBegins)+14;
	    ui->edtExtrasDevel->setText(statistics.mid(extrasDevelBegins,extrasDevelEnds-extrasDevelBegins-14));
	}else{
	    ui->edtExtras->setText("0");
	    ui->edtExtrasTesting->setText("0");
	    ui->edtExtrasDevel->setText("0");
	}

    }else if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="audio/mpeg"){

    }

    reply->deleteLater();

    ui->lblDownloading->setPixmap(QPixmap("/invisible.png"));
}

void MainWindowMaemo::on_edtPackage_textChanged(const QString &arg1)
{
    ui->edtPackage->setText(arg1.toLower());
    ui->edtExtras->clear();
    ui->edtExtrasTesting->clear();
    ui->edtExtrasDevel->clear();
    ui->edtTotal->clear();
}

void MainWindowMaemo::on_actionAbout_triggered(){
    DAbout *d=new DAbout(0);
    d->exec();
    delete d;
}

void MainWindowMaemo::on_actionClear_triggered(){
    ui->edtPackage->clear();
    ui->edtExtras->clear();
    ui->edtExtrasTesting->clear();
    ui->edtExtrasDevel->clear();
    ui->edtTotal->clear();
}
