/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of dlh.

    dlh is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dlh is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dlh.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DLH_H
#define DLH_H

#include <QtGui/QWidget>
#include <QMutex>
#include <QtDBus/QtDBus>

#include "start.h"
#include "view.h"

namespace Ui
{
    class Widget;
}

class Widget : public QWidget
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.nokia.dlh")

public:
    Widget(QWidget *parent = 0);
    ~Widget();

private:
    Ui::Widget *ui;

    QMutex mutex;
    Start* start;
    View* view;

public slots:
    void free();
    Q_NOREPLY void CallStartDialog();
    Q_NOREPLY void CallViewDialog();
    void openAboutDialog();
    void reset();
};

#endif // DLH_H
