/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.1
import com.nokia.meego 1.0

Page {
    id: settings
    anchors.fill: parent
    signal set(int numOfColumns, int numOfRows, int numOfMines)
    signal close()

    tools: ToolBarLayout {
        visible: true
        ToolIcon {
            iconId: "toolbar-back";
            onClicked: { settings.close(); }
        }
    }
    Column {
        id: options
        width: parent.width
        anchors.centerIn: parent
        Row {
            width: parent.width
            Label {
                text: 'Rows: '
                width: lblColumns.width
            }
            Label {
                text: rowSlider.value
                width: 50
            }
            Slider {
                id: rowSlider
                minimumValue: 2
                maximumValue: 50
                stepSize:1
                value: game.rows
                width: parent.width - lblColumns.width - 50
            }
        }
        Row {
            width: parent.width
            Label {
                id: lblColumns
                text: 'Columns: '
            }
            Label {
                text: columnSlider.value
                width: 50
            }
            Slider {
                id: columnSlider
                minimumValue: 2
                maximumValue: 50
                stepSize:1
                value: game.columns
                width: parent.width - lblColumns.width - 50
            }
        }
        Row {
            width: parent.width
            Label {
                text: 'Mines: '
                width: lblColumns.width
            }
            Label {
                text: mineSlider.value
                width: 50
            }
            Slider {
                id: mineSlider
                minimumValue: 2
                maximumValue: columnSlider.value * rowSlider.value - 1
                stepSize:1
                value: game.mines
                width: parent.width - lblColumns.width - 50
            }
        }
    }
    Button {
        text: 'Save'
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: options.bottom

        /*platformStyle: ButtonStyle {
            fontPixelSize: 30
            position: "[horizontal-center]"
        }*/
        onClicked: {
            settings.set(columnSlider.value, rowSlider.value, mineSlider.value)
        }
    }
}
