/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.0

Grid {
    id: table
    columns: 10
    rows: 10
    /*height:  (parent.width  / 10) * (rows * (1 + spacing) )
    width: (parent.width / 10) * (columns * (1 + spacing) )*/
    anchors.fill: parent
    spacing: 5
    property int fieldSize: 80
    property int openedFields: 0
    property int numOfMines: 14
    property int flags: 0

    signal lost
    signal won
    signal flag(int number)

    Repeater {
        model: table.columns * table.rows
        delegate: Field {
            width: table.fieldSize -table.spacing
            height: table.fieldSize - table.spacing
            onOpened: table.fieldOpened()
            onGameOver:  table.gameOver()
            onFlagged: {
                if (status) flags++;
                else flags--;
                table.flag(flags);
            }
        }
    }

    Component.onCompleted: {
        initialize();
        newGame();
    }

    function initialize() {
        for (var pos = 0; pos < (table.columns * table.rows); pos++) {
            var neighbors = Array();
            var c;
            var row;
            var cols;
            for (var y = -1; y <= 1; y++) {
                for (var x = -1; x <= 1; x++) {
                    if (!x && !y) continue;
                    row = Math.floor(pos/table.rows);
                    cols = pos - row * table.columns;
                    if ((cols + x < 0) || (cols + x >= table.columns) || (row + y < 0) || (row + y >= table.rows)) continue;
                    c = table.children[(row + y) * table.columns + cols + x];
                    if (c !== null) {
                        neighbors.push(c);
                    }
                }
            }
            table.children[pos].setNeighbors(neighbors);
        }
    }

    function newGame() {
        openedFields = 0;
        flags = 0;
        for (var i = 0; i < (table.columns * table.rows); i++) {
            table.children[i].initialize();
        }
        var position;
        for (var i = 0; i < numOfMines; i++) {
            position = Math.floor(Math.random()*(table.columns * table.rows));
            while (table.children[position].mine) {
                position = Math.floor(Math.random()*(table.columns * table.rows));
            }
            table.children[position].addMine(position);
        }
    }

    function fieldOpened() {
        openedFields++;
        if (openedFields == (table.columns * table.rows - table.numOfMines)) {
            table.won();
        }
    }

    function gameOver() {
        table.lost();
    }
}
