/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.0

Grid {
    id: table
    columns: 10
    rows: 10
    height:  parent.width
    width: parent.width
    //anchors.fill: parent
    spacing: 5
    property int openedFields: 0
    property int numOfMines: Math.round(table.columns * table.rows / 7)

    signal lost
    signal won

    Repeater {
        model: table.columns * table.rows
        delegate: Field {
            width: (table.width - table.columns * table.spacing) / table.columns
            height: (table.height - table.rows * table.spacing) / table.rows
            onOpened: table.fieldOpened()
            onGameOver:  table.gameOver()
        }
    }

    Component.onCompleted: {
        for (var i = 0; i < (table.columns * table.rows); i++) {
            table.children[i].setNeighbors();
        }
        newGame();
    }

    function newGame() {
        openedFields = 0;
        for (var i = 0; i < (table.columns * table.rows); i++) {
            table.children[i].initialize();
        }
        var position;
        for (var i = 0; i < numOfMines; i++) {
            position = Math.floor(Math.random()*(table.columns * table.rows));
            while (table.children[position].mine) {
                position = Math.floor(Math.random()*(table.columns * table.rows));
            }
            table.children[position].addMine(position);
        }
    }

    function fieldOpened() {
        openedFields++;
        if (openedFields == (table.columns * table.rows - table.numOfMines)) {
            table.won();
        }
    }

    function gameOver() {
        table.lost();
    }
}
