#ifndef SHARETOFACEBOOKDIALOG_H
#define SHARETOFACEBOOKDIALOG_H

#include "abstractdialog.h"
#include "../base/videoitem.h"

class QLineEdit;
class QTextEdit;
class QPushButton;
class QDialogButtonBox;
class QScrollArea;
class QGridLayout;

class ShareToFacebookDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit ShareToFacebookDialog(QSharedPointer<VideoItem> video, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void shareVideo();
    
private:
    QSharedPointer<VideoItem> m_video;
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QTextEdit *m_messageEdit;
    QScrollArea *m_scrollArea;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QGridLayout *m_grid;
};

#endif // SHARETOFACEBOOKDIALOG_H
