#ifndef LINKGOOGLEACCOUNTDIALOG_H
#define LINKGOOGLEACCOUNTDIALOG_H

#include "abstractdialog.h"

class QLineEdit;
class QPushButton;
class QDialogButtonBox;
class QScrollArea;
class QGridLayout;
class QStringListModel;
class QListView;
class QLabel;
class QModelIndex;

class SuggestedUsernamesDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SuggestedUsernamesDialog(QWidget *parent = 0);
    void setSuggestedUsernames(const QStringList &usernames);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void usernameChosen(const QString &username);

private:
    QStringListModel *m_model;
    QListView *m_listView;
    QGridLayout *m_grid;
};

class LinkGoogleAccountDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit LinkGoogleAccountDialog(QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onUsernameTextChanged(const QString &text);
    void showSuggestedUsernames(const QStringList &usernames);
    void checkUsername();
    void onUsernameAvailable();
    void onUsernameUnavailable();

private:
    QLineEdit *m_usernameEdit;
    QLabel *m_messageLabel;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
    SuggestedUsernamesDialog *m_dialog;
};

#endif // LINKGOOGLEACCOUNTDIALOG_H
