#ifndef SELECTIONMODELS_H
#define SELECTIONMODELS_H

#include "enums.h"
#include <QStandardItemModel>

class SelectionModel : public QStandardItemModel
{
    Q_OBJECT

public:
    explicit SelectionModel(QObject *parent = 0);
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    void addItem(const QString &name, const QVariant &value);
    Q_INVOKABLE QString name(int row) const;
    Q_INVOKABLE QVariant value(int row) const;
    Q_INVOKABLE QVariantMap get(int row) const;
    Q_INVOKABLE inline Qt::Alignment textAlignment() const { return m_textAlignment; }
    Q_INVOKABLE inline void setTextAlignment(Qt::Alignment alignment) { m_textAlignment = alignment; }

private:
    Qt::Alignment m_textAlignment;
    QHash<int, QByteArray> m_roleNames;
};

class SearchOrderModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit SearchOrderModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class SearchTypeModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

    Q_PROPERTY(bool showGroups
               READ showGroups
               WRITE setShowGroups
               NOTIFY showGroupsChanged)

public:
    explicit SearchTypeModel(QObject *parent = 0);
    inline bool showGroups() const { return m_groups; }
    void setShowGroups(bool show);

signals:
    void showGroupsChanged(bool show);
    void countChanged(int count);

private:
    bool m_groups;
};

class SearchDurationModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit SearchDurationModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class SearchTimeModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit SearchTimeModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class VideoServiceModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit VideoServiceModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class ScreenOrientationModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ScreenOrientationModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class YouTubePermissionModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit YouTubePermissionModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class YouTubeUploadCategoryModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit YouTubeUploadCategoryModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class DailymotionUploadCategoryModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit DailymotionUploadCategoryModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class SharingModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit SharingModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class LanguageModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit LanguageModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class ThemeModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ThemeModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class ActiveColorModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ActiveColorModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class MediaPlayerModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit MediaPlayerModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class TransferPriorityModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit TransferPriorityModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class ConcurrentTransfersModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ConcurrentTransfersModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class NetworkProxyTypeModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit NetworkProxyTypeModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

#endif // SELECTIONMODELS_H
