#ifndef DAILYMOTIONUSERLISTMODEL_H
#define DAILYMOTIONUSERLISTMODEL_H

#include "abstractuserlistmodel.h"

class DailymotionUserListModel : public AbstractUserListModel
{
    Q_OBJECT

    Q_PROPERTY(QUrl feed
               READ feed
               WRITE setFeed)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)

public:
    explicit DailymotionUserListModel(QObject *parent = 0);
    inline QUrl feed() const { return m_feed; }
    void setFeed(const QUrl &feed);
    inline bool loading() const { return m_loading; }

public slots:
    void clear();
    void reset();
    void getUsers(QUrl feed = QUrl());
    void search(const QString &query = QString());
    void getMoreUsers();

private slots:
    void addUsers();
    inline void onError() { setError(true); setLoading(false); }
    inline void stopLoading() { this->setLoading(false); }

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline QString query() const { return m_query; }
    inline void setQuery(const QString &query) { m_query = query; }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged(bool loading);
    void countChanged(int count);

private:
    QUrl m_feed;
    QString m_query;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // DAILYMOTIONUSERLISTMODEL_H
